/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.Simple;

public class Integral
extends Simple {
    protected Parameter<Double> param_In_Offset;
    private double[] integrals;
    private double[] times;

    public Integral() {
        this.param_In_Offset = new Parameter<Double>(this.parameters, "In Offset", 0.0);
    }

    @Override
    public void init() {
        super.init();
        this.integrals = new double[this.fields.length];
        this.times = new double[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            this.integrals[i] = 0.0;
            this.times[i] = Double.NaN;
        }
    }

    @Override
    protected double preProcessValue(int idx, double time, double in) {
        if (!Double.isNaN(this.times[idx])) {
            int n = idx;
            this.integrals[n] = this.integrals[n] + (in + this.param_In_Offset.get()) * (time - this.times[idx]);
        }
        this.times[idx] = time;
        return this.integrals[idx];
    }
}

