/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.ulog.Getter;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;

public class ATan2
extends PlotProcessor {
    protected Parameter<String> param_Field_X;
    protected Parameter<String> param_Field_Y;
    protected Parameter<Double> param_Angle_Offset;
    private Getter getterX;
    private Getter getterY;

    public ATan2() {
        this.param_Field_X = new Parameter<String>(this.parameters, "Field X", "ATTITUDE_POSITION.vel[0]");
        this.param_Field_Y = new Parameter<String>(this.parameters, "Field Y", "ATTITUDE_POSITION.vel[1]");
        this.param_Angle_Offset = new Parameter<Double>(this.parameters, "Angle Offset", 0.0);
    }

    @Override
    public void init() {
        this.getterX = this.addGetter(this.param_Field_X.get());
        this.getterY = this.addGetter(this.param_Field_Y.get());
        this.addSeries();
    }

    @Override
    public void process(double time) {
        if (this.getterX.isUpdated() || this.getterY.isUpdated()) {
            Object x = this.getterX.get();
            Object y = this.getterY.get();
            if (x instanceof Number && y instanceof Number) {
                double a = Math.atan2(((Number)y).doubleValue(), ((Number)x).doubleValue());
                int a_2pi = (int)Math.round((a += this.param_Angle_Offset.get() + Math.PI) / 2.0 / Math.PI - 0.5);
                this.addPoint(0, time, a -= ((double)a_2pi * 2.0 + 1.0) * Math.PI);
            }
        }
    }
}

