/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class ProcessorPreset {
    private String title;
    private String processorType;
    private Map<String, Object> parameters;
    private Map<String, Color> colors;

    public ProcessorPreset(String title, String processorType, Map<String, Object> parameters, Map<String, Color> colors) {
        this.title = title;
        this.processorType = processorType;
        this.parameters = parameters;
        this.colors = colors;
    }

    public static ProcessorPreset unpackJSONObject(JSONObject json) throws IOException {
        JSONObject jsonParameters = json.getJSONObject("Parameters");
        HashMap<String, Object> parametersNew = new HashMap<String, Object>();
        Iterator<String> iterator = jsonParameters.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String keyStr = key = iterator.next();
            parametersNew.put(keyStr, jsonParameters.get(keyStr).toString());
        }
        JSONObject jsonColors = json.getJSONObject("Colors");
        HashMap<String, Color> colorsNew = new HashMap<String, Color>();
        Iterator<String> iterator2 = jsonColors.keySet().iterator();
        while (iterator2.hasNext()) {
            String key;
            String keyStr = key = iterator2.next();
            colorsNew.put(keyStr, new Color(Integer.parseInt(jsonColors.get(keyStr).toString(), 16)));
        }
        return new ProcessorPreset(json.getString("Title"), json.getString("ProcessorType"), parametersNew, colorsNew);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public void setProcessorType(String processorType) {
        this.processorType = processorType;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Map<String, Color> getColors() {
        return this.colors;
    }

    public void setColors(Map<String, Color> colors) {
        this.colors = colors;
    }

    public JSONObject packJSONObject() throws IOException {
        JSONObject json = new JSONObject();
        json.put("Title", this.title);
        json.put("ProcessorType", this.processorType);
        json.put("Parameters", new JSONObject(this.parameters));
        HashMap<String, String> jsonColors = new HashMap<String, String>();
        for (Map.Entry<String, Color> entry : this.colors.entrySet()) {
            jsonColors.put(entry.getKey(), Integer.toHexString(entry.getValue().getRGB()).substring(2, 8));
        }
        json.put("Colors", new JSONObject(jsonColors));
        return json;
    }

    public Map.Entry<String, Object> getParameter(int i) {
        ArrayList<Map.Entry<String, Object>> paramEntries = new ArrayList<Map.Entry<String, Object>>(this.parameters.entrySet());
        Collections.sort(paramEntries, new Comparator<Map.Entry>(this){

            @Override
            public int compare(Map.Entry o1, Map.Entry o2) {
                return ((String)o1.getKey()).compareTo((String)o2.getKey());
            }
        });
        ArrayList<Map.Entry<String, Color>> colorsEntries = new ArrayList<Map.Entry<String, Color>>(this.colors.entrySet());
        Collections.sort(paramEntries, new Comparator<Map.Entry>(this){

            @Override
            public int compare(Map.Entry o1, Map.Entry o2) {
                return ((String)o1.getKey()).compareTo((String)o2.getKey());
            }
        });
        paramEntries.addAll(colorsEntries);
        return (Map.Entry)paramEntries.get(i);
    }

    public ProcessorPreset clone() {
        return new ProcessorPreset(this.title, this.processorType, new HashMap<String, Object>(this.parameters), new HashMap<String, Color>(this.colors));
    }

    public String toString() {
        return this.title + " [" + this.processorType + "]";
    }
}

