/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.ProcessorPreset;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Preset {
    private String title;
    private List<ProcessorPreset> processorPresets;

    public Preset() {
        this.title = "";
        this.processorPresets = new ArrayList<ProcessorPreset>();
    }

    public Preset(String title, List<ProcessorPreset> processorPresets) {
        this.title = title;
        this.processorPresets = processorPresets;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ProcessorPreset> getProcessorPresets() {
        return this.processorPresets;
    }

    public JSONObject packJSONObject() throws IOException {
        JSONObject json = new JSONObject();
        json.put("Title", this.title);
        JSONArray jsonProcessorPresets = new JSONArray();
        for (ProcessorPreset pp : this.processorPresets) {
            jsonProcessorPresets.put(pp.packJSONObject());
        }
        json.put("ProcessorPresets", jsonProcessorPresets);
        return json;
    }

    public static Preset unpackJSONObject(JSONObject json) throws IOException {
        JSONArray jsonProcessorPresets = json.getJSONArray("ProcessorPresets");
        ArrayList<ProcessorPreset> processorPresets = new ArrayList<ProcessorPreset>();
        for (int i = 0; i < jsonProcessorPresets.length(); ++i) {
            processorPresets.add(ProcessorPreset.unpackJSONObject(jsonProcessorPresets.getJSONObject(i)));
        }
        return new Preset(json.getString("Title"), processorPresets);
    }

    public String toString() {
        return this.title;
    }
}

