/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.ParamValueTableCellEditor;
import com.microavia.plot.ParamValueTableCellRenderer;
import com.microavia.plot.PlotApp;
import com.microavia.plot.ProcessorPreset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class ParametersPanel
extends JPanel {
    private PlotApp app;
    private JTable parametersTable;
    private DefaultTableModel parametersTableModel;
    private TableModelListener parameterChangedListener;
    private static String colorParamPrefix = "Color ";
    private static final NumberFormat doubleNumberFormat = NumberFormat.getInstance(Locale.ROOT);

    public ParametersPanel(PlotApp app) {
        super(new BorderLayout());
        this.app = app;
        this.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.parametersTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }
        };
        this.parametersTableModel.addColumn("Parameter");
        this.parametersTableModel.addColumn("Value");
        this.parametersTable = new JTable(this.parametersTableModel);
        this.parametersTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "startEditing");
        this.parametersTable.setSelectionMode(0);
        this.parametersTable.getColumnModel().getColumn(1).setCellEditor(new ParamValueTableCellEditor(app));
        this.parametersTable.getColumnModel().getColumn(1).setCellRenderer(new ParamValueTableCellRenderer());
        this.parametersTable.putClientProperty("JTable.autoStartsEdit", false);
        this.parametersTable.putClientProperty("terminateEditOnFocusLost", true);
        this.parameterChangedListener = e -> {
            if (e.getType() == 0) {
                int row = e.getFirstRow();
                this.onParameterChanged(row);
                app.setEditingProcessor(null);
            }
        };
        this.parametersTableModel.addTableModelListener(this.parameterChangedListener);
        this.add((Component)this.parametersTable, "Center");
    }

    void showProcessorParameters() {
        if (this.app.getEditingProcessor() != null) {
            return;
        }
        while (this.parametersTableModel.getRowCount() > 0) {
            this.parametersTableModel.removeRow(0);
        }
        ProcessorPreset selectedProcessor = this.app.getSelectedProcessor();
        if (selectedProcessor != null) {
            Map<String, Object> params = selectedProcessor.getParameters();
            ArrayList<String> param_keys = new ArrayList<String>(params.keySet());
            Collections.sort(param_keys);
            for (String key : param_keys) {
                this.parametersTableModel.addRow(new Object[]{key, ParametersPanel.formatParameterValue(params.get(key))});
            }
            Map<String, Color> colors = selectedProcessor.getColors();
            ArrayList<String> color_keys = new ArrayList<String>(colors.keySet());
            Collections.sort(color_keys);
            for (String key : color_keys) {
                this.parametersTableModel.addRow(new Object[]{colorParamPrefix + key, colors.get(key)});
            }
        }
    }

    private void onParameterChanged(int row) {
        if (this.app.getEditingProcessor() != null && this.app.getEditingProcessor() == this.app.getSelectedProcessor()) {
            String key = this.parametersTableModel.getValueAt(row, 0).toString();
            Object value = this.parametersTableModel.getValueAt(row, 1);
            if (value instanceof Color) {
                this.app.getEditingProcessor().getColors().put(key.substring(colorParamPrefix.length(), key.length()), (Color)value);
                this.app.setChartColors();
            }
            try {
                this.app.updatePresetParameters(this.app.getEditingProcessor(), Collections.singletonMap(key, value.toString()));
                this.app.updatePresetEdited(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.app.setStatus("Error: " + String.valueOf(e));
            }
            if (!(value instanceof Color)) {
                this.parametersTableModel.removeTableModelListener(this.parameterChangedListener);
                this.showProcessorParameters();
                this.parametersTableModel.addTableModelListener(this.parameterChangedListener);
                this.parametersTable.addRowSelectionInterval(row, row);
                this.app.processFile();
            }
        }
    }

    private static Object formatParameterValue(Object value) {
        Object returnValue = value instanceof Double ? doubleNumberFormat.format(value) : (value instanceof Color ? value : value.toString());
        return returnValue;
    }

    static {
        doubleNumberFormat.setGroupingUsed(false);
        doubleNumberFormat.setMinimumFractionDigits(1);
        doubleNumberFormat.setMaximumFractionDigits(10);
    }
}

