/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import java.awt.Color;

public class ColorSupplier {
    private Color[] paintSequence = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.BLACK, Color.LIGHT_GRAY, Color.ORANGE, Color.RED.darker(), Color.GREEN.darker(), Color.BLUE.darker(), Color.CYAN.darker(), Color.MAGENTA.darker(), Color.ORANGE.darker()};
    private int[] paintUsage = new int[this.paintSequence.length];

    public Color[] getPaintSequence() {
        return this.paintSequence;
    }

    public Color getPaint(int idx) {
        return this.paintSequence[idx];
    }

    public void resetColorsUsed() {
        for (int i = 0; i < this.paintSequence.length; ++i) {
            this.paintUsage[i] = 0;
        }
    }

    public void markColorUsed(Color color) {
        for (int i = 0; i < this.paintSequence.length; ++i) {
            if (!color.equals(this.paintSequence[i])) continue;
            this.markColorUsed(i);
        }
    }

    public void markColorUsed(int color_idx) {
        int n = color_idx;
        this.paintUsage[n] = this.paintUsage[n] + 1;
    }

    public Color getNextColor(String field) {
        int minUsage = -1;
        int color_idx = 0;
        for (int i = 0; i < this.paintSequence.length; ++i) {
            if (this.paintUsage[i] < minUsage || minUsage < 0) {
                minUsage = this.paintUsage[i];
                color_idx = i;
            }
            if (minUsage != 0) continue;
            this.markColorUsed(color_idx);
            break;
        }
        return this.paintSequence[color_idx];
    }
}

