/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.ColorSupplier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;

class ColorParamTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private ColorSupplier colorSupplier;
    private Color color;
    private JComboBox select;

    public ColorParamTableCellEditor(ColorSupplier colorSupplier) {
        this.colorSupplier = colorSupplier;
        this.select = new JComboBox();
        this.select.setRenderer(new ColorCellRenderer());
        for (Color paint : colorSupplier.getPaintSequence()) {
            this.select.addItem(paint);
        }
    }

    public JComboBox getComponent() {
        return this.select;
    }

    @Override
    public Object getCellEditorValue() {
        return this.colorSupplier.getPaint(this.select.getSelectedIndex());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.color = (Color)value;
        this.select.setSelectedItem(this.color);
        return this.select;
    }

    private class ColorCellRenderer
    extends JLabel
    implements ListCellRenderer {
        boolean setBg = false;

        public ColorCellRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(0, 15));
        }

        @Override
        public void setBackground(Color bg) {
            if (!this.setBg) {
                return;
            }
            super.setBackground(bg);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBg = true;
            this.setText("");
            this.setBackground((Color)value);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBg = false;
            if (isSelected) {
                this.setBorder(BorderFactory.createLineBorder(Color.white, 2));
            }
            return this;
        }
    }
}

