/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.math;

public class LatLonAlt {
    public static double RADIUS_OF_EARTH = 6371000.0;
    public final double lat;
    public final double lon;
    public final double alt;

    public LatLonAlt(double lat, double lon, double alt) {
        this.lat = lat;
        this.lon = lon;
        this.alt = alt;
    }

    public LatLonAlt add(double[] vector) {
        return new LatLonAlt(this.lat + vector[0] / RADIUS_OF_EARTH * 180.0 / Math.PI, this.lon + vector[1] / (Math.cos(this.lat * Math.PI / 180.0) * RADIUS_OF_EARTH) * 180.0 / Math.PI, this.alt - vector[2]);
    }

    public double[] sub(LatLonAlt pos) {
        return new double[]{(this.lat - pos.lat) * Math.PI / 180.0 * RADIUS_OF_EARTH, (this.lon - pos.lon) * Math.PI / 180.0 * Math.cos(this.lat * Math.PI / 180.0) * RADIUS_OF_EARTH, pos.alt - this.alt};
    }

    public boolean isFinite() {
        return Double.isFinite(this.lat) && Double.isFinite(this.lon) && Double.isFinite(this.alt);
    }

    public LatLonAlt clone() {
        return new LatLonAlt(this.lat, this.lon, this.alt);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LatLonAlt) {
            LatLonAlt other = (LatLonAlt)obj;
            return this.lat == other.lat && this.lon == other.lon && this.alt == other.alt;
        }
        return false;
    }

    public String toString() {
        return String.format("lat=%s lon=%s alt=%s", this.lat, this.lon, this.alt);
    }
}

