/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.math;

import com.microavia.jmalib.math.LatLonAlt;

public class GlobalPositionProjector {
    private static double r_earth = 6371000.0;
    private boolean inited;
    private double lat0;
    private double lon0;
    private double alt0;
    private double cos_lat0;
    private double sin_lat0;

    public void reset() {
        this.inited = false;
    }

    public boolean isInited() {
        return this.inited;
    }

    public void init(LatLonAlt ref) {
        this.inited = true;
        this.lat0 = ref.lat * Math.PI / 180.0;
        this.lon0 = ref.lon * Math.PI / 180.0;
        this.alt0 = ref.alt;
        this.cos_lat0 = Math.cos(this.lat0);
        this.sin_lat0 = Math.sin(this.lat0);
    }

    public double[] project(LatLonAlt p) {
        double cos_d_lon;
        double cos_lat;
        if (!this.inited) {
            throw new RuntimeException("Not initialized");
        }
        double lat_rad = p.lat * Math.PI / 180.0;
        double lon_rad = p.lon * Math.PI / 180.0;
        double sin_lat = Math.sin(lat_rad);
        double c = Math.acos(this.sin_lat0 * sin_lat + this.cos_lat0 * (cos_lat = Math.cos(lat_rad)) * (cos_d_lon = Math.cos(lon_rad - this.lon0)));
        double k = c == 0.0 ? 1.0 : c / Math.sin(c);
        double y = k * cos_lat * Math.sin(lon_rad - this.lon0) * r_earth;
        double x = k * (this.cos_lat0 * sin_lat - this.sin_lat0 * cos_lat * cos_d_lon) * r_earth;
        double z = this.alt0 - p.alt;
        return new double[]{x, y, z};
    }

    public LatLonAlt reproject(double[] v) {
        double lon_rad;
        double lat_rad;
        if (!this.inited) {
            throw new RuntimeException("Not initialized");
        }
        double x_rad = v[0] / r_earth;
        double y_rad = v[1] / r_earth;
        double c = Math.sqrt(x_rad * x_rad + y_rad * y_rad);
        double sin_c = Math.sin(c);
        double cos_c = Math.cos(c);
        if (c != 0.0) {
            lat_rad = Math.asin(cos_c * this.sin_lat0 + x_rad * sin_c * this.cos_lat0 / c);
            lon_rad = this.lon0 + Math.atan2(y_rad * sin_c, c * this.cos_lat0 * cos_c - x_rad * this.sin_lat0 * sin_c);
        } else {
            lat_rad = this.lat0;
            lon_rad = this.lon0;
        }
        return new LatLonAlt(lat_rad * 180.0 / Math.PI, lon_rad * 180.0 / Math.PI, this.alt0 - v[2]);
    }
}

