/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log.ulog;

import com.microavia.jmalib.log.ulog.Codec;
import com.microavia.jmalib.log.ulog.Getter;
import com.microavia.jmalib.log.ulog.StructParser;
import com.microavia.jmalib.log.ulog.SubscriptionException;
import com.microavia.jmalib.log.ulog.model.ArrayType;
import com.microavia.jmalib.log.ulog.model.StructType;
import com.microavia.jmalib.log.ulog.model.Type;
import com.microavia.jmalib.log.ulog.model.TypeClass;
import com.microavia.jmalib.log.ulog.model.VectorType;
import java.nio.ByteBuffer;

public class Subscription {
    private final Codec codec;
    private final String topicName;
    private final Type topicType;
    private final StructParser structParser;
    private int multiId;
    private Object value;
    private boolean updated;

    public Subscription() {
        this.codec = null;
        this.topicName = null;
        this.topicType = null;
        this.structParser = null;
    }

    Subscription(Codec codec, String topicName, Type topicType) {
        this.codec = codec;
        this.topicName = topicName;
        this.topicType = topicType;
        this.structParser = (StructParser)codec.getValueParser(topicType);
    }

    public Getter createGetter(String path) throws SubscriptionException {
        return this.createGetter(path, -1);
    }

    public Getter createGetter(String path, int multiIdFilter) throws SubscriptionException {
        return this.createGetter(new Getter(this, "", null, this.topicType, multiIdFilter), path, multiIdFilter);
    }

    private Getter createGetter(Getter parent, String path, int multiIdFilter) throws SubscriptionException {
        if (!parent.isValid()) {
            throw new SubscriptionException("Parent getter is not valid when creating getter '" + (String)path + "'");
        }
        switch (parent.getType().getTypeClass()) {
            case STRUCT: {
                String[] pathParts = ((String)path).split("[\\[.]", 2);
                String fieldName = pathParts[0];
                Getter fieldGetter = this.createFieldValueGetter(fieldName, (StructType)parent.type, multiIdFilter);
                if (fieldGetter == null) {
                    throw new SubscriptionException("Could not find field '" + fieldName + "' in struct '" + parent.getType().getTypeName() + "'");
                }
                Getter getter = parent.getterFunction == null ? fieldGetter : new Getter(this, (String)path, obj -> fieldGetter.getterFunction.get(parent.getterFunction.get(obj)), fieldGetter.getType(), multiIdFilter);
                if (pathParts.length == 1) {
                    return getter;
                }
                return this.createGetter(getter, pathParts[1], multiIdFilter);
            }
            case ARRAY: 
            case VECTOR: {
                String elTypeStr;
                String[] idxParts = ((String)path).split("]", 2);
                int idx = Integer.parseInt(idxParts[0]);
                if (idx < 0) {
                    throw new SubscriptionException("Array index out of bounds: idx=" + idx + " < 0");
                }
                path = "[" + (String)path;
                if (parent.getType().getTypeClass() == TypeClass.ARRAY) {
                    ArrayType arrType = (ArrayType)parent.getType();
                    if (idx >= arrType.getSize()) {
                        throw new SubscriptionException("Array index out of bounds: idx=" + idx + " >= " + arrType.getSize());
                    }
                    elTypeStr = arrType.getElementType();
                } else {
                    VectorType vecType = (VectorType)parent.getType();
                    elTypeStr = vecType.getElementType();
                }
                Type elType = this.codec.getTypeDescription(elTypeStr);
                Getter idxGetter = new Getter(this, (String)path, obj -> ((Object[])obj)[idx], elType, multiIdFilter);
                Getter getter = parent.getterFunction == null ? idxGetter : new Getter(this, parent.getPath() + (String)path, obj -> idxGetter.getterFunction.get(parent.getterFunction.get(obj)), idxGetter.getType(), multiIdFilter);
                if (idxParts.length == 1 || idxParts[1].isEmpty()) {
                    return getter;
                }
                return this.createGetter(getter, idxParts[1], multiIdFilter);
            }
        }
        throw new SubscriptionException("Invalid parent type class '" + String.valueOf((Object)parent.getType().getTypeClass()) + "' when creating getter for path '" + (String)path + "'");
    }

    private Getter createFieldValueGetter(String fieldName, StructType structType, int multiIdFilter) {
        StructType.Field[] fields = structType.getFields();
        for (int i = 0; i < fields.length; ++i) {
            StructType.Field f = fields[i];
            if (!f.name().equals(fieldName)) continue;
            int fieldIdx = i;
            Getter.GetterFunction g = obj -> {
                if (obj instanceof Object[]) {
                    Object[] arr = (Object[])obj;
                    return arr[fieldIdx];
                }
                return null;
            };
            Type fieldType = this.codec.getTypeDescription(f.typeName());
            return new Getter(this, fieldName, g, fieldType, multiIdFilter);
        }
        return null;
    }

    public boolean update(ByteBuffer buffer, int mId) {
        if (this.structParser != null) {
            this.value = this.structParser.parse(buffer);
            this.multiId = mId;
            this.updated = true;
            return true;
        }
        return false;
    }

    public void update(Object val, int mId) {
        this.value = val;
        this.multiId = mId;
        this.updated = true;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isValid() {
        return this.structParser != null;
    }

    public int getMultiId() {
        return this.multiId;
    }

    public Object getValue() {
        return this.value;
    }

    void clearUpdated() {
        this.updated = false;
    }
}

