/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log.ulog;

import com.microavia.jmalib.log.ulog.ArrayParser;
import com.microavia.jmalib.log.ulog.BytesParser;
import com.microavia.jmalib.log.ulog.Parser;
import com.microavia.jmalib.log.ulog.StringParser;
import com.microavia.jmalib.log.ulog.StructParser;
import com.microavia.jmalib.log.ulog.VectorParser;
import com.microavia.jmalib.log.ulog.model.ArrayType;
import com.microavia.jmalib.log.ulog.model.BitsetType;
import com.microavia.jmalib.log.ulog.model.EnumType;
import com.microavia.jmalib.log.ulog.model.StructType;
import com.microavia.jmalib.log.ulog.model.Type;
import com.microavia.jmalib.log.ulog.model.TypeClass;
import com.microavia.jmalib.log.ulog.model.VectorType;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class Codec {
    private static Charset charset = Charset.forName("latin1");
    private Map<String, Type> typeDescriptions = new HashMap<String, Type>();

    Charset getCharset() {
        return charset;
    }

    public void addStructType(String typeName, String fieldsListStr) {
        String[] fieldsStr = fieldsListStr.split(";");
        StructType.Field[] fields = new StructType.Field[fieldsStr.length];
        for (int i = 0; i < fieldsStr.length; ++i) {
            String fieldTypeStr;
            String fs = fieldsStr[i];
            String[] p = fs.split(" ", 2);
            if (p.length == 2) {
                fieldTypeStr = p[0];
                Type fieldType = this.getBuildInTypeDescription(fieldTypeStr);
                if (fieldType != null) {
                    fieldTypeStr = fieldType.getTypeName();
                }
            } else {
                throw new RuntimeException("Error parsing struct field: " + fs);
            }
            fields[i] = new StructType.Field(p[1], fieldTypeStr);
        }
        StructType structType = new StructType(typeName, fields);
        this.typeDescriptions.put(typeName, structType);
    }

    public Type getTypeDescription(String typeName) {
        if (typeName.endsWith("]")) {
            int idx = typeName.indexOf(91);
            String elementType = typeName.substring(0, idx);
            String sizeStr = typeName.substring(idx + 1, typeName.length() - 1);
            if (sizeStr.isEmpty()) {
                return new VectorType(elementType);
            }
            int size = Integer.parseInt(sizeStr);
            return new ArrayType(elementType, size);
        }
        Type descrBuiltin = this.getBuildInTypeDescription(typeName);
        if (descrBuiltin != null) {
            return descrBuiltin;
        }
        return this.typeDescriptions.get(typeName);
    }

    public Parser getValueParser(String typeName) {
        Type descr = this.getTypeDescription(typeName);
        if (descr == null) {
            return null;
        }
        return this.getValueParser(descr);
    }

    public Parser getValueParser(Type descr) {
        return switch (descr.getTypeClass()) {
            case TypeClass.SCALAR -> Codec.getScalarParser(descr.getTypeName());
            case TypeClass.ENUM -> Codec.getScalarParser(((EnumType)descr).getBaseType());
            case TypeClass.BITSET -> Codec.getScalarParser(((BitsetType)descr).getBaseType());
            case TypeClass.BYTES -> new BytesParser();
            case TypeClass.STRING -> new StringParser(this);
            case TypeClass.ARRAY -> {
                ArrayType arrDescr = (ArrayType)descr;
                yield new ArrayParser(this.getValueParser(arrDescr.getElementType()), arrDescr.getSize());
            }
            case TypeClass.VECTOR -> {
                VectorType vecDescr = (VectorType)descr;
                yield new VectorParser(this.getValueParser(vecDescr.getElementType()));
            }
            case TypeClass.STRUCT -> {
                StructType structDescr = (StructType)descr;
                Parser[] fields = new Parser[structDescr.getFields().length];
                for (int i = 0; i < structDescr.getFields().length; ++i) {
                    StructType.Field field = structDescr.getFields()[i];
                    fields[i] = this.getValueParser(field.typeName());
                }
                yield new StructParser(fields);
            }
            default -> null;
        };
    }

    Type getBuildInTypeDescription(String typeName) {
        return switch (typeName) {
            case "float", "float32" -> new Type("float32", TypeClass.SCALAR);
            case "double", "float64" -> new Type("float64", TypeClass.SCALAR);
            case "char", "int8_t", "int8" -> new Type("int8", TypeClass.SCALAR);
            case "bool" -> new Type("bool", TypeClass.SCALAR);
            case "uint8_t", "uint8" -> new Type("uint8", TypeClass.SCALAR);
            case "int16_t", "int16" -> new Type("int16", TypeClass.SCALAR);
            case "uint16_t", "uint16" -> new Type("uint16", TypeClass.SCALAR);
            case "int32_t", "int32" -> new Type("int32", TypeClass.SCALAR);
            case "uint32_t", "uint32" -> new Type("uint32", TypeClass.SCALAR);
            case "int64_t", "int64" -> new Type("int64", TypeClass.SCALAR);
            case "uint64_t", "uint64" -> new Type("uint64", TypeClass.SCALAR);
            case "string" -> new Type("string", TypeClass.STRING);
            case "bytes" -> new Type("bytes", TypeClass.BYTES);
            default -> null;
        };
    }

    static Parser getScalarParser(String type) {
        return switch (type) {
            case "float32" -> ByteBuffer::getFloat;
            case "float64" -> ByteBuffer::getDouble;
            case "int8" -> b -> (int)b.get();
            case "bool" -> b -> b.get() != 0;
            case "uint8" -> b -> b.get() & 0xFF;
            case "int16" -> b -> (int)b.getShort();
            case "uint16" -> b -> b.getShort() & 0xFFFF;
            case "int32" -> ByteBuffer::getInt;
            case "uint32" -> b -> (long)b.getInt() & 0xFFFFFFFFL;
            case "int64", "uint64" -> ByteBuffer::getLong;
            default -> b -> {
                throw new RuntimeException("Unsupported scalar type: " + type);
            };
        };
    }

    public String objectToString(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str;
        }
        if (obj instanceof Object[]) {
            byte b;
            int n;
            Object[] arr = (Object[])obj;
            byte[] bs = new byte[arr.length];
            for (n = 0; n < arr.length && (b = (byte)((Integer)arr[n]).intValue()) != 0; ++n) {
                bs[n] = b;
            }
            return new String(bs, 0, n, charset);
        }
        return obj.toString();
    }
}

