/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors.tools;

public class HighPassFilter {
    private double inLast = 0.0;
    private double valueFiltered = 0.0;
    private double tLast = Double.NaN;
    private double f = 1.0;
    private double rc = 1.0 / (this.f * 2.0 * Math.PI);

    public void setF(double f) {
        this.f = f;
        this.rc = f == 0.0 ? 0.0 : 1.0 / (f * 2.0 * Math.PI);
    }

    public void setT(double t) {
        this.rc = t / (Math.PI * 2);
        this.f = t == 0.0 ? 0.0 : 1.0 / t;
    }

    public void reset() {
        this.tLast = Double.NaN;
    }

    public double getOutput(double t, double in) {
        if (this.rc == 0.0) {
            this.valueFiltered = 0.0;
            return in;
        }
        if (Double.isNaN(this.tLast)) {
            this.tLast = t;
            this.inLast = in;
            this.valueFiltered = 0.0;
            return 0.0;
        }
        double dt = t - this.tLast;
        this.valueFiltered = this.rc / (this.rc + dt) * (this.valueFiltered + in - this.inLast);
        this.inLast = in;
        this.tLast = t;
        return this.valueFiltered;
    }

    public void setInput(double in) {
        this.inLast = in;
    }
}

