/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.LogReader;
import com.microavia.jmalib.log.ulog.Getter;
import com.microavia.jmalib.log.ulog.Subscription;
import com.microavia.jmalib.log.ulog.SubscriptionException;
import com.microavia.plot.MarkersList;
import com.microavia.plot.PlotItem;
import com.microavia.plot.Series;
import com.microavia.plot.XYPoint;
import com.microavia.plot.processors.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PlotProcessor {
    protected static final String WHITESPACE_RE = "[ \t]+";
    protected LogReader logReader;
    protected List<Getter> getters = new ArrayList<Getter>();
    protected Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    protected Map<String, String> fieldsList = new HashMap<String, String>();
    private double skipOut = 0.0;
    private List<PlotItem> seriesList = new ArrayList<PlotItem>();
    private List<XYPoint> lastPoints = new ArrayList<XYPoint>();

    protected Getter addGetter(String fullPath) {
        String[] p = fullPath.split("\\.", 2);
        if (this.logReader != null && p.length == 2) {
            return this.addGetter(p[0], p[1]);
        }
        return new Getter();
    }

    protected Getter addGetter(String topicName, String path) {
        Getter getter;
        Subscription sub = null;
        for (Getter getter2 : this.getters) {
            if (!getter2.getSubscription().getTopicName().equals(topicName)) continue;
            sub = getter2.getSubscription();
            break;
        }
        try {
            if (sub == null) {
                sub = this.logReader.addSubscription(topicName);
            }
            getter = sub.createGetter(path);
        }
        catch (SubscriptionException e) {
            e.printStackTrace();
            getter = new Getter();
        }
        this.getters.add(getter);
        return getter;
    }

    private static Object castValue(Object valueOld, Object valueNewObj) {
        String valueNewStr = valueNewObj.toString();
        Object valueNew = valueNewObj;
        if (valueOld instanceof String) {
            valueNew = valueNewStr;
        } else if (valueOld instanceof Double) {
            valueNew = Double.parseDouble(valueNewStr);
        } else if (valueOld instanceof Float) {
            valueNew = Float.valueOf(Float.parseFloat(valueNewStr));
        } else if (valueOld instanceof Integer) {
            valueNew = Integer.parseInt(valueNewStr);
        } else if (valueOld instanceof Long) {
            valueNew = Long.parseLong(valueNewStr);
        } else if (valueOld instanceof Boolean) {
            char firstChar = valueNewStr.toLowerCase().charAt(0);
            valueNew = firstChar == 'f' || firstChar == 'n' || "0".equals(valueNewStr) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return valueNew;
    }

    public abstract void init();

    public void setLogReader(LogReader logReader) {
        this.logReader = logReader;
    }

    public void setSkipOut(double skipOut) {
        this.skipOut = skipOut;
    }

    public void setFieldsList(Map<String, String> fieldsList) {
        this.fieldsList = fieldsList;
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    public void setParameters(Map<String, Object> parametersNew) {
        for (Map.Entry<String, Object> entry : parametersNew.entrySet()) {
            Object oldValue;
            String key = entry.getKey();
            Parameter param = this.parameters.get(key);
            if (param == null || (oldValue = param.get()) == null) continue;
            param.set(PlotProcessor.castValue(oldValue, entry.getValue()));
        }
    }

    protected int addSeries() {
        int idx = this.seriesList.size();
        this.seriesList.add(new Series("", this.skipOut));
        this.lastPoints.add(null);
        return idx;
    }

    protected int addSeries(String label) {
        int idx = this.seriesList.size();
        this.seriesList.add(new Series(label, this.skipOut));
        this.lastPoints.add(null);
        return idx;
    }

    protected int addMarkersList() {
        int idx = this.seriesList.size();
        this.seriesList.add(new MarkersList(""));
        return idx;
    }

    protected int addMarkersList(String label) {
        int idx = this.seriesList.size();
        this.seriesList.add(new MarkersList(label));
        return idx;
    }

    public List<PlotItem> getSeriesList() {
        return this.seriesList;
    }

    protected void addPoint(int seriesIdx, double time, double value) {
        ((Series)this.seriesList.get(seriesIdx)).addPoint(time, value);
    }

    protected void addMarker(int seriesIdx, double time, String label) {
        ((MarkersList)this.seriesList.get(seriesIdx)).addMarker(time, label);
    }

    public abstract void process(double var1);

    public String getProcessorType() {
        return this.getClass().getSimpleName();
    }
}

