/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.ulog.Getter;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;
import com.microavia.plot.processors.tools.ParseUtil;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class NEDProjection
extends PlotProcessor {
    protected Parameter<String> param_Field_Vec;
    protected Parameter<String> param_Field_Att;
    protected Parameter<Boolean> param_Reverse;
    protected Parameter<Double> param_Offset_Roll;
    protected Parameter<Double> param_Offset_Pitch;
    protected Parameter<Double> param_Offset_Yaw;
    protected Parameter<String> param_Offset_In;
    private Getter getterVec;
    private Getter getterAtt;
    private final double[] attQArr;
    private Rotation attQ;
    private final double[] vecArr;
    private Rotation offsQ;
    private Vector3D offsIn;

    public NEDProjection() {
        this.param_Field_Vec = new Parameter<String>(this.parameters, "Field", "MAG_REPORT.value");
        this.param_Field_Att = new Parameter<String>(this.parameters, "Field Att", "ATTITUDE_POSITION.att_q");
        this.param_Reverse = new Parameter<Boolean>(this.parameters, "Reverse", false);
        this.param_Offset_Roll = new Parameter<Double>(this.parameters, "Offset Roll", 0.0);
        this.param_Offset_Pitch = new Parameter<Double>(this.parameters, "Offset Pitch", 0.0);
        this.param_Offset_Yaw = new Parameter<Double>(this.parameters, "Offset Yaw", 0.0);
        this.param_Offset_In = new Parameter<String>(this.parameters, "Offset In", "");
        this.attQArr = new double[4];
        this.attQ = Rotation.IDENTITY;
        this.vecArr = new double[3];
        this.offsQ = Rotation.IDENTITY;
        this.offsIn = Vector3D.ZERO;
    }

    @Override
    public void init() {
        this.offsQ = new Rotation(RotationOrder.XYZ, RotationConvention.FRAME_TRANSFORM, this.param_Offset_Roll.get() * Math.PI / 180.0, this.param_Offset_Pitch.get() * Math.PI / 180.0, this.param_Offset_Yaw.get() * Math.PI / 180.0);
        this.offsIn = ParseUtil.parseStringArray3D(this.param_Offset_In.get());
        this.getterVec = this.addGetter(this.param_Field_Vec.get());
        this.getterAtt = this.addGetter(this.param_Field_Att.get());
        this.addSeries("X");
        this.addSeries("Y");
        this.addSeries("Z");
    }

    @Override
    public void process(double time) {
        if (this.getterAtt.getSubscription().isUpdated()) {
            ParseUtil.parseArray(this.getterAtt.get(), this.attQArr);
            this.attQ = new Rotation(this.attQArr[0], this.attQArr[1], this.attQArr[2], this.attQArr[3], false);
        }
        if (this.getterVec.getSubscription().isUpdated() && ParseUtil.parseArray(this.getterVec.get(), this.vecArr)) {
            Vector vec = new Vector3D(this.vecArr).add((Vector)this.offsIn);
            Rotation q = this.attQ.compose(this.offsQ, RotationConvention.FRAME_TRANSFORM);
            Vector3D vecRot = this.param_Reverse.get() != false ? q.applyTo((Vector3D)vec) : q.applyInverseTo((Vector3D)vec);
            this.addPoint(0, time, vecRot.getX());
            this.addPoint(1, time, vecRot.getY());
            this.addPoint(2, time, vecRot.getZ());
        }
    }
}

