/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.ulog.Getter;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;
import com.microavia.plot.processors.tools.ParseUtil;

public class Abs
extends PlotProcessor {
    protected Parameter<String> param_Fields;
    protected Parameter<Double> param_Scale;
    protected Parameter<String> param_Offset_In;
    private double[] offsIn;

    public Abs() {
        this.param_Fields = new Parameter<String>(this.parameters, "Fields", "ATTITUDE_POSITION.vel[0] ATTITUDE_POSITION.vel[1]");
        this.param_Scale = new Parameter<Double>(this.parameters, "Scale", 1.0);
        this.param_Offset_In = new Parameter<String>(this.parameters, "Offset In", "");
    }

    @Override
    public void init() {
        String[] fields;
        this.offsIn = ParseUtil.parseStringArray(this.param_Offset_In.get());
        for (String field : fields = this.param_Fields.get().split("[ \t]+")) {
            this.addGetter(field);
        }
        this.addSeries();
    }

    @Override
    public void process(double time) {
        double s = 0.0;
        for (int i = 0; i < this.getters.size(); ++i) {
            Getter getter = (Getter)this.getters.get(i);
            Object v = getter.get();
            if (v instanceof Number) {
                double d = ((Number)v).doubleValue();
                if (this.offsIn.length > i) {
                    d += this.offsIn[i];
                }
                s += d * d;
                continue;
            }
            if (!(v instanceof Object[])) continue;
            for (Object a : (Object[])v) {
                if (!(a instanceof Number)) continue;
                double d = ((Number)a).doubleValue();
                s += d * d;
            }
        }
        this.addPoint(0, time, Math.sqrt(s) * this.param_Scale.get());
    }
}

