/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.ulog.Getter;
import com.microavia.jmalib.log.ulog.Subscription;
import com.microavia.jmalib.log.ulog.ULogReader;
import com.microavia.plot.export.AbstractTrackReader;
import com.microavia.plot.export.TrackPoint;
import com.microavia.plot.export.TrackReaderConfiguration;
import java.io.EOFException;
import java.io.IOException;

public class ULogTrackReader
extends AbstractTrackReader {
    private Subscription subAttPos;
    private Subscription subSysStatus;
    private Getter getterPosValid;
    private Getter getterPosLat;
    private Getter getterPosLon;
    private Getter getterPosAltEl;
    private Getter getterUnd;
    private Getter getterAttQ;
    private Getter getterMode;

    ULogTrackReader(ULogReader reader, TrackReaderConfiguration config) throws IOException, FormatErrorException {
        super(reader, config);
        this.subAttPos = reader.addSubscription("ATTITUDE_POSITION");
        this.getterPosValid = this.subAttPos.createGetter("valid_pos");
        this.getterPosLat = this.subAttPos.createGetter("lat");
        this.getterPosLon = this.subAttPos.createGetter("lon");
        this.getterPosAltEl = this.subAttPos.createGetter("alt_el");
        this.getterUnd = this.subAttPos.createGetter("und");
        this.getterAttQ = this.subAttPos.createGetter("att_q");
        this.subSysStatus = reader.addSubscription("SYSTEM_STATUS");
        this.getterMode = this.subSysStatus.createGetter("mode");
    }

    @Override
    public TrackPoint readNextPoint() throws IOException {
        block4: {
            Number mode;
            long t;
            Object[] attQ;
            Number und;
            Number altEl;
            Number lon;
            Number lat;
            Number valid;
            do {
                try {
                    t = this.readUpdate();
                }
                catch (EOFException e) {
                    break block4;
                }
                valid = (Number)this.getterPosValid.get();
                lat = (Number)this.getterPosLat.get();
                lon = (Number)this.getterPosLon.get();
                altEl = (Number)this.getterPosAltEl.get();
                und = (Number)this.getterUnd.get();
                attQ = (Object[])this.getterAttQ.get();
                mode = (Number)this.getterMode.get();
            } while (valid == null || lat == null || lon == null || altEl == null || und == null || attQ == null || valid.intValue() == 0);
            double[] attArr = new double[]{0.0, 0.0, 0.0, 1.0};
            for (int i = 0; i < 4; ++i) {
                Object v = attQ[i];
                if (!(v instanceof Number)) continue;
                attArr[i] = ((Number)v).doubleValue();
            }
            return new TrackPoint(lat.doubleValue(), lon.doubleValue(), altEl.doubleValue() + und.doubleValue() + this.config.getAltitudeOffset(), attArr, t + this.reader.getUTCTimeReferenceMicroseconds(), this.getFlightMode(mode));
        }
        return null;
    }

    private String getFlightMode(Number mode) {
        if (mode != null) {
            switch (mode.intValue()) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MANUAL";
                }
                case 2: {
                    return "ALTCTL";
                }
                case 3: {
                    return "POSCTL";
                }
                case 4: {
                    return "ACRO";
                }
                case 5: {
                    return "DESCEND";
                }
                case 6: {
                    return "LAND";
                }
                case 7: {
                    return "RTH";
                }
                case 8: {
                    return "MISSION";
                }
            }
            return String.format("UNKNOWN(%s)", mode.intValue());
        }
        return null;
    }
}

