/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.LogReader;
import com.microavia.plot.export.TrackReader;
import com.microavia.plot.export.TrackReaderConfiguration;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractTrackReader
implements TrackReader {
    protected final LogReader reader;
    protected final TrackReaderConfiguration config;
    private long timeNext = 0L;

    public AbstractTrackReader(LogReader reader, TrackReaderConfiguration config) throws IOException, FormatErrorException {
        this.reader = reader;
        this.config = config;
        this.reader.seek(this.config.getTimeStart());
    }

    protected long readUpdate() throws IOException {
        long t;
        do {
            if ((t = this.reader.readUpdate()) <= this.config.getTimeEnd()) continue;
            throw new EOFException("Reached configured export limit.");
        } while (t < this.timeNext);
        if (this.timeNext == 0L) {
            this.timeNext = t;
        }
        this.timeNext += this.config.getTimeInterval();
        return t;
    }
}

