/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.PlotApp;
import com.microavia.plot.ProcessorPreset;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class EditProcessorDialog
extends JDialog {
    private PlotApp app;
    private JButton buttonApply;
    private JButton buttonCancel;
    private JTextField titleField;
    private JList processorTypesList;
    private DefaultListModel processorTypesListModel;
    private String[] processorTypes;
    private ProcessorPreset origProcessorPreset = null;

    EditProcessorDialog(PlotApp app, String[] processorTypes) {
        super((Frame)app, "Edit Processor");
        this.app = app;
        this.processorTypes = processorTypes;
        this.createUIComponents();
        this.pack();
        this.setDefaultCloseOperation(1);
        this.getRootPane().registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    String getProcessorTitle() {
        return this.titleField.getText();
    }

    ProcessorPreset getOrigProcessorPreset() {
        return this.origProcessorPreset;
    }

    String getProcessorType() {
        return (String)this.processorTypesList.getSelectedValue();
    }

    void display(ProcessorPreset processorPreset) {
        if (this.processorTypesListModel.size() == 0) {
            for (String processorType : this.processorTypes) {
                this.processorTypesListModel.addElement(processorType);
            }
            this.processorTypesList.setSelectedValue("Simple", true);
        }
        if (processorPreset != null) {
            this.origProcessorPreset = processorPreset;
            this.titleField.setText(processorPreset.getTitle());
            this.processorTypesList.setSelectedValue(processorPreset.getProcessorType(), true);
        } else {
            this.origProcessorPreset = null;
            this.titleField.setText("");
        }
        this.titleField.requestFocus();
        this.setVisible(true);
    }

    private void onApply() {
        this.setVisible(false);
        this.app.onAddProcessorDialogOK();
    }

    private void onCancel() {
        this.setVisible(false);
    }

    private void createUIComponents() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getRootPane().setPreferredSize(new Dimension(300, 400));
        this.titleField = new JTextField();
        this.getContentPane().add((Component)this.titleField, "First");
        this.processorTypesListModel = new DefaultListModel();
        this.processorTypesList = new JList(this.processorTypesListModel);
        this.getContentPane().add((Component)new JScrollPane(this.processorTypesList), "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonApply = new JButton("Apply");
        this.buttonApply.addActionListener(e -> this.onApply());
        buttonsPanel.add(this.buttonApply);
        this.getRootPane().setDefaultButton(this.buttonApply);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(e -> this.onCancel());
        buttonsPanel.add(this.buttonCancel);
        this.getContentPane().add((Component)buttonsPanel, "Last");
    }
}

