/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log.ulog;

import com.microavia.jmalib.log.BinaryLogReader;
import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.ulog.Codec;
import com.microavia.jmalib.log.ulog.Parser;
import com.microavia.jmalib.log.ulog.Subscription;
import com.microavia.jmalib.log.ulog.SubscriptionException;
import com.microavia.jmalib.log.ulog.Topic;
import com.microavia.jmalib.log.ulog.model.ArrayType;
import com.microavia.jmalib.log.ulog.model.StructType;
import com.microavia.jmalib.log.ulog.model.Type;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ULogReader
extends BinaryLogReader {
    private static final byte SYNC_BYTE = 62;
    private static final byte MESSAGE_TYPE_STRUCT = 70;
    private static final byte MESSAGE_TYPE_TOPIC = 65;
    private static final byte MESSAGE_TYPE_DATA = 68;
    private static final byte MESSAGE_TYPE_INFO = 73;
    private static final byte MESSAGE_TYPE_PARAMETER = 80;
    private String systemName = "";
    private String systemConfig = "";
    private long dataStart = 0L;
    private Map<String, Topic> topicByName = new HashMap<String, Topic>();
    private Map<String, String> fieldsList = null;
    private Map<Integer, List<Subscription>> subscriptions = new HashMap<Integer, List<Subscription>>();
    private ArrayList<Subscription> updatedSubscriptions = new ArrayList();
    private long sizeUpdates = -1L;
    private long sizeMicroseconds = -1L;
    private long startMicroseconds = -1L;
    private long timeLast = Long.MIN_VALUE;
    private long utcTimeReference = -1L;
    private Map<String, Object> version = new HashMap<String, Object>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private List<Exception> errors = new ArrayList<Exception>();
    private int logVersion = 0;
    private int headerSize = 4;
    private int msgDataTimestampOffset = 3;
    private Codec codec = new Codec();

    public ULogReader(String fileName) throws IOException, FormatErrorException {
        super(fileName);
        this.updateStatistics();
    }

    @Override
    public String getFormat() {
        return "ULog v" + this.logVersion;
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    @Override
    public String getSystemConfig() {
        return this.systemConfig;
    }

    @Override
    public long getSizeUpdates() {
        return this.sizeUpdates;
    }

    @Override
    public long getStartMicroseconds() {
        return this.startMicroseconds;
    }

    @Override
    public long getSizeMicroseconds() {
        return this.sizeMicroseconds;
    }

    @Override
    public long getUTCTimeReferenceMicroseconds() {
        return this.utcTimeReference;
    }

    @Override
    public Map<String, Object> getVersion() {
        return this.version;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    private void updateStatistics() throws IOException, FormatErrorException {
        this.position(0L);
        this.fillBuffer(4);
        byte[] logVersionBytes = new byte[4];
        this.buffer.get(logVersionBytes);
        String logVersionStr = new String(logVersionBytes, Charset.forName("latin1"));
        if (logVersionStr.startsWith("ULG")) {
            this.logVersion = Integer.parseInt(logVersionStr.substring(3));
            this.headerSize = 4;
            this.msgDataTimestampOffset = this.logVersion >= 2 ? 3 : 2;
        } else {
            throw new FormatErrorException("Unsupported file format");
        }
        this.startMicroseconds = -1L;
        this.sizeUpdates = 0L;
        this.fieldsList = new HashMap<String, String>();
        this.timeLast = Long.MIN_VALUE;
        try {
            while (true) {
                this.readMessage(this::handleHeaderMessage);
            }
        }
        catch (EOFException eOFException) {
            this.sizeMicroseconds = this.timeLast - this.startMicroseconds;
            this.seek(0L);
            return;
        }
    }

    @Override
    public Subscription addSubscription(String topicName) {
        Topic topic = this.topicByName.get(topicName);
        if (topic == null) {
            throw new SubscriptionException("Topic not found: " + topicName);
        }
        Type topicType = this.codec.getTypeDescription(topic.getTypeName());
        Subscription sub = new Subscription(this.codec, topicName, topicType, -1);
        this.subscriptions.putIfAbsent(topic.getId(), new ArrayList());
        this.subscriptions.get(topic.getId()).add(sub);
        return sub;
    }

    @Override
    public void removeAllSubscriptions() {
        this.subscriptions.clear();
        this.updatedSubscriptions.clear();
    }

    @Override
    public long readUpdate() throws IOException {
        for (Subscription sub : this.updatedSubscriptions) {
            sub.clearUpdated();
        }
        this.updatedSubscriptions.clear();
        this.timeLast = Long.MIN_VALUE;
        do {
            this.readMessage(this::handleDataMessage);
        } while (this.timeLast == Long.MIN_VALUE);
        return this.timeLast;
    }

    @Override
    public List<Subscription> getUpdatedSubscriptions() {
        return this.updatedSubscriptions;
    }

    @Override
    public boolean seek(long seekTime) throws IOException {
        this.position(this.dataStart);
        this.timeLast = Long.MIN_VALUE;
        if (seekTime == 0L) {
            return true;
        }
        try {
            while (this.timeLast < seekTime) {
                this.readMessage((pos, msgType, msgSize) -> {
                    if (msgType == 68) {
                        this.timeLast = this.buffer.getLong(this.buffer.position() + this.msgDataTimestampOffset);
                        if (this.timeLast >= seekTime) {
                            this.position(pos);
                            return;
                        }
                    }
                    this.buffer.position(this.buffer.position() + msgSize);
                });
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    @Override
    public Map<String, String> getFields() {
        return this.fieldsList;
    }

    private void readMessage(MessageHandler handler) throws IOException {
        long pos;
        while (true) {
            this.fillBuffer(this.headerSize);
            pos = this.position();
            byte sync = this.buffer.get();
            if (sync == 62) break;
            this.errors.add(new FormatErrorException(pos, String.format("Wrong sync byte: 0x%02X (expected 0x%02X)", sync & 0xFF, 62)));
        }
        int msgType = this.buffer.get() & 0xFF;
        int msgSize = this.buffer.getShort() & 0xFFFF;
        try {
            this.fillBuffer(msgSize);
        }
        catch (EOFException e) {
            this.errors.add(new FormatErrorException(pos, "Unexpected end of file"));
            throw e;
        }
        try {
            handler.handleMessage(pos, msgType, msgSize);
        }
        catch (Exception e) {
            this.errors.add(new FormatErrorException(pos, "Error parsing message typeName: " + msgType, e));
        }
    }

    private void handleHeaderMessage(long pos, int msgType, int msgSize) throws IOException {
        switch (msgType) {
            case 68: {
                if (this.dataStart == 0L) {
                    this.dataStart = pos;
                }
                long timestamp = this.buffer.getLong(this.buffer.position() + this.msgDataTimestampOffset);
                if (this.startMicroseconds < 0L) {
                    this.startMicroseconds = timestamp;
                }
                this.timeLast = timestamp;
                ++this.sizeUpdates;
                this.buffer.position(this.buffer.position() + msgSize);
                break;
            }
            case 70: {
                if (this.logVersion <= 1) {
                    int msgId = this.buffer.get() & 0xFF;
                    int formatLen = this.buffer.getShort() & 0xFFFF;
                    String descrStr = this.getString(this.buffer, formatLen);
                    String[] descr = this.getString(this.buffer, formatLen).split(":");
                    if (descr.length <= 1) {
                        this.errors.add(new FormatErrorException(pos, String.format("Invalid struct description: %s", descrStr)));
                        break;
                    }
                    this.codec.addStructType(descr[0], descr[1]);
                    break;
                }
                String descrStr = this.getString(this.buffer, msgSize);
                String[] descr = descrStr.split(":");
                if (descr.length <= 1) {
                    this.errors.add(new FormatErrorException(pos, String.format("Invalid struct description: %s", descrStr)));
                    break;
                }
                this.codec.addStructType(descr[0], descr[1]);
                break;
            }
            case 65: {
                int msgId = this.buffer.getShort() & 0xFFFF;
                String[] descr = this.getString(this.buffer, msgSize - 2).split(":");
                String name = descr[0];
                String typeName = descr[1];
                Type typeDescr = this.codec.getTypeDescription(typeName);
                if (typeDescr == null) {
                    this.errors.add(new FormatErrorException(pos, String.format("Unknown topic struct typeName: %s", typeName)));
                    break;
                }
                Topic topic = new Topic(name, typeDescr.getTypeName(), msgId);
                this.topicByName.put(name, topic);
                this.addFieldsToList(pos, name, typeDescr);
                break;
            }
            case 73: {
                int keyLen = this.buffer.get() & 0xFF;
                String[] keyDescr = this.getString(this.buffer, keyLen).split(" ");
                String key = keyDescr[1];
                Parser parser = this.codec.getValueParser(keyDescr[0]);
                if (parser == null) {
                    this.errors.add(new FormatErrorException(pos, "Error parsing info: " + key));
                    break;
                }
                Object value = parser.parse(this.buffer);
                switch (key) {
                    case "sys_name": {
                        this.systemName = this.codec.objectToString(value);
                        break;
                    }
                    case "sys_config": {
                        this.systemConfig = this.codec.objectToString(value);
                        break;
                    }
                    case "ver_hw": {
                        this.version.put("HW", this.codec.objectToString(value));
                        break;
                    }
                    case "ver_sw": {
                        this.version.put("FW", this.codec.objectToString(value));
                        break;
                    }
                    case "time_ref_utc": {
                        this.utcTimeReference = ((Number)value).longValue();
                    }
                }
                break;
            }
            case 80: {
                int keyLen = this.buffer.get() & 0xFF;
                String[] keyDescr = this.getString(this.buffer, keyLen).split(" ");
                String key = keyDescr[1];
                Parser parser = this.codec.getValueParser(keyDescr[0]);
                if (parser == null) {
                    this.errors.add(new FormatErrorException(pos, "Error parsing parameter: " + key));
                    break;
                }
                Object value = parser.parse(this.buffer);
                this.parameters.put(key, value);
                break;
            }
            default: {
                this.buffer.position(this.buffer.position() + msgSize);
                this.errors.add(new FormatErrorException(pos, "Unknown message typeName: " + msgType));
            }
        }
        int sizeParsed = (int)(this.position() - pos - (long)this.headerSize);
        if (sizeParsed != msgSize) {
            this.errors.add(new FormatErrorException(pos, "Message size mismatch, parsed: " + sizeParsed + ", msg size: " + msgSize + ", msgType: " + msgType));
            this.buffer.position(this.buffer.position() + msgSize - sizeParsed);
        }
    }

    private void addFieldsToList(long pos, String path, Type typeDescr) {
        block0 : switch (typeDescr.getTypeClass()) {
            case STRUCT: {
                for (StructType.Field field : ((StructType)typeDescr).getFields()) {
                    if (field.name().startsWith("_")) continue;
                    Type type = this.codec.getTypeDescription(field.typeName());
                    if (type == null) {
                        this.errors.add(new FormatErrorException(pos, "Invalid type of field " + field.typeName() + ": " + field.name()));
                        break block0;
                    }
                    this.addFieldsToList(pos, String.format("%s.%s", path, field.name()), type);
                }
                break;
            }
            case ARRAY: {
                ArrayType arrDescr = (ArrayType)typeDescr;
                int size = arrDescr.getSize();
                for (int i = 0; i < size; ++i) {
                    this.addFieldsToList(pos, String.format("%s[%s]", path, i), this.codec.getTypeDescription(arrDescr.getElementType()));
                }
                break;
            }
            default: {
                this.fieldsList.put(path, typeDescr.getTypeName());
            }
        }
    }

    private void handleDataMessage(long pos, int msgType, int msgSize) {
        int bp = this.buffer.position();
        if (msgType == 68) {
            int msgId = this.logVersion >= 2 ? this.buffer.getShort() & 0xFFFF : this.buffer.get() & 0xFF;
            List<Subscription> subs = this.subscriptions.get(msgId);
            if (subs != null) {
                int multiId = this.buffer.get() & 0xFF;
                long timestamp = this.buffer.getLong();
                for (Subscription sub : subs) {
                    if (!sub.update(this.buffer, multiId)) continue;
                    this.updatedSubscriptions.add(sub);
                    this.timeLast = timestamp;
                }
            }
        } else {
            this.errors.add(new FormatErrorException("Unexpected message typeName: " + msgType));
        }
        this.buffer.position(bp + msgSize);
    }

    private String getString(ByteBuffer buffer, int len) {
        byte[] strBuf = new byte[len];
        buffer.get(strBuf);
        String[] p = new String(strBuf, this.codec.getCharset()).split("\u0000");
        return p.length > 0 ? p[0] : "";
    }

    @Override
    public List<Exception> getErrors() {
        return this.errors;
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    static interface MessageHandler {
        public void handleMessage(long var1, int var3, int var4) throws IOException;
    }
}

