/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors.tools;

import com.microavia.plot.processors.tools.Filter;

public class Batterworth2pLPF
extends Filter {
    private double a1 = 0.0;
    private double a2 = 0.0;
    private double b0 = 0.0;
    private double b1 = 0.0;
    private double b2 = 0.0;
    private double[] elements = new double[2];

    @Override
    public void setCutoffFreqFactor(double cutoffFreqFactor) {
        super.setCutoffFreqFactor(cutoffFreqFactor);
        double r = Math.tan(1.5707963267948966 * this.cutoffFreqFactor);
        double c = 1.0 + 2.0 * Math.cos(0.7853981633974483) * r + r * r;
        this.b0 = r * r / c;
        this.b1 = 2.0 * this.b0;
        this.b2 = this.b0;
        this.a1 = 2.0 * (r * r - 1.0) / c;
        this.a2 = (1.0 - 2.0 * Math.cos(0.7853981633974483) * r + r * r) / c;
        this.reset(0.0);
    }

    @Override
    public double apply(double sample) {
        if (this.cutoffFreqFactor <= 0.0) {
            return sample;
        }
        double element_0 = sample - this.elements[0] * this.a1 - this.elements[1] * this.a2;
        if (Double.isNaN(element_0)) {
            element_0 = sample;
        }
        double output = element_0 * this.b0 + this.elements[0] * this.b1 + this.elements[1] * this.b2;
        this.elements[1] = this.elements[0];
        this.elements[0] = element_0;
        return output;
    }

    @Override
    public double reset(double sample) {
        double v;
        this.elements[0] = v = sample / (this.b0 + this.b1 + this.b2);
        this.elements[1] = v;
        return this.apply(sample);
    }
}

