/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.Subscription;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;
import com.microavia.plot.processors.tools.HighPassFilter;
import com.microavia.plot.processors.tools.LowPassFilter;
import com.microavia.plot.processors.tools.ParseUtil;
import java.util.ArrayList;
import java.util.List;

public class Simple
extends PlotProcessor {
    protected Parameter<String> param_Fields;
    protected Parameter<Double> param_Delay;
    protected Parameter<Double> param_LPF;
    protected Parameter<Double> param_HPF;
    protected Parameter<Double> param_Scale;
    protected Parameter<String> param_Offset;
    protected List<LowPassFilter> lowPassFilters;
    protected List<HighPassFilter> highPassFilters;
    protected List<Subscription> subscriptions;
    protected String[] fields;
    private double[] offs;

    public Simple() {
        this.param_Fields = new Parameter<String>(this.parameters, "Fields", "ATTITUDE_POSITION.alt_baro");
        this.param_Delay = new Parameter<Double>(this.parameters, "Delay", 0.0);
        this.param_LPF = new Parameter<Double>(this.parameters, "LPF", 0.0);
        this.param_HPF = new Parameter<Double>(this.parameters, "HPF", 0.0);
        this.param_Scale = new Parameter<Double>(this.parameters, "Scale", 1.0);
        this.param_Offset = new Parameter<String>(this.parameters, "Offset", "");
        this.lowPassFilters = new ArrayList<LowPassFilter>();
        this.highPassFilters = new ArrayList<HighPassFilter>();
        this.subscriptions = new ArrayList<Subscription>();
    }

    @Override
    public void init() {
        this.offs = ParseUtil.parseStringArray(this.param_Offset.get());
        for (String field : this.fields = this.param_Fields.get().split("[ \t]+")) {
            this.subscriptions.add(this.addSubscription(field));
            this.addSeries(field);
            LowPassFilter lowPassFilter = new LowPassFilter();
            lowPassFilter.setF(this.param_LPF.get());
            this.lowPassFilters.add(lowPassFilter);
            HighPassFilter highPassFilter = new HighPassFilter();
            highPassFilter.setF(this.param_HPF.get());
            this.highPassFilters.add(highPassFilter);
        }
    }

    protected double preProcessValue(int idx, double time, double in) {
        return in;
    }

    protected double postProcessValue(int idx, double time, double in) {
        return in;
    }

    @Override
    public void process(double time) {
        for (int i = 0; i < this.subscriptions.size(); ++i) {
            Object v;
            Subscription sub = this.subscriptions.get(i);
            if (!sub.isUpdated() || !((v = sub.getValue()) instanceof Number)) continue;
            double out = this.preProcessValue(i, time, ((Number)v).doubleValue());
            if (Double.isNaN(out)) {
                this.addPoint(i, time, Double.NaN);
                continue;
            }
            out = this.lowPassFilters.get(i).apply(time, out);
            out = this.highPassFilters.get(i).getOutput(time, out);
            out = this.postProcessValue(i, time, out) * this.param_Scale.get();
            if (this.offs.length > i) {
                out += this.offs[i];
            }
            this.addPoint(i, time + this.param_Delay.get(), out);
        }
    }
}

