/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.Subscription;
import com.microavia.jmalib.math.RotationUtil;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;
import com.microavia.plot.processors.tools.Batterworth2pLPF;
import com.microavia.plot.processors.tools.DelayLine;
import com.microavia.plot.processors.tools.Filter;
import com.microavia.plot.processors.tools.LowPassFilter;

public class PosRatePIDControlSimulator
extends PlotProcessor {
    private DelayLine<Double> delayLine = new DelayLine();
    private Filter rateLPF = new Batterworth2pLPF();
    private LowPassFilter controlLPF = new LowPassFilter();
    private LowPassFilter outLPF = new LowPassFilter();
    private int posSPAxis = -1;
    private double[] qArray = new double[4];
    private double rateIntegral;
    private double pos;
    private double rate;
    private double posSP;
    private double rateSP;
    private double rateFF;
    private double timeStep;
    private double timePrev;
    private Parameter<Double> param_Time_Step = new Parameter<Double>(this.parameters, "Time Step", 0.004);
    private Parameter<Double> param_Thrust_T = new Parameter<Double>(this.parameters, "Thrust T", 0.3);
    private Parameter<Double> param_Thrust_Delay = new Parameter<Double>(this.parameters, "Thrust Delay", 0.03);
    private Parameter<Double> param_Thrust_K = new Parameter<Double>(this.parameters, "Thrust K", 100.0);
    private Parameter<Double> param_Ctl_Out_T = new Parameter<Double>(this.parameters, "Ctl Out T", 0.4);
    private Parameter<Double> param_Ctl_Pos_P = new Parameter<Double>(this.parameters, "Ctl Pos P", 5.0);
    private Parameter<Double> param_Ctl_Rate_Limit = new Parameter<Double>(this.parameters, "Ctl Rate Limit", 0.0);
    private Parameter<Double> param_Ctl_Rate_P = new Parameter<Double>(this.parameters, "Ctl Rate P", 0.1);
    private Parameter<Double> param_Ctl_Rate_I = new Parameter<Double>(this.parameters, "Ctl Rate I", 1.0);
    private Parameter<Double> param_Ctl_Rate_D = new Parameter<Double>(this.parameters, "Ctl Rate D", 5.0);
    private Parameter<Double> param_Ctl_Rate_I_Limit = new Parameter<Double>(this.parameters, "Ctl Rate I Limit", 0.0);
    private Parameter<Double> param_Ctl_Out_Limit = new Parameter<Double>(this.parameters, "Ctl Out Limit", 0.0);
    private Parameter<Double> param_Ctl_Rate_FF = new Parameter<Double>(this.parameters, "Ctl Rate FF", 1.0);
    private Parameter<Double> param_Acc_Scale = new Parameter<Double>(this.parameters, "Acc Scale", 0.0);
    private Parameter<Double> param_Drag = new Parameter<Double>(this.parameters, "Drag", 0.0);
    private Parameter<Boolean> param_Use_Rate_SP = new Parameter<Boolean>(this.parameters, "Use Rate SP", false);
    private Parameter<Double> param_Rate_LPF = new Parameter<Double>(this.parameters, "Rate LPF", 0.0);
    private Parameter<String> param_Field_Pos_SP = new Parameter<String>(this.parameters, "Field Pos SP", "R ATTITUDE_SETPOINT.q");
    private Parameter<String> param_Field_Rate_SP = new Parameter<String>(this.parameters, "Field Rate SP", "ATTITUDE_SETPOINT.rates[0]");
    private Parameter<String> param_Field_Rate_FF = new Parameter<String>(this.parameters, "Field Rate FF", "ATTITUDE_SETPOINT.rates_ff[0]");
    private Subscription subPosSP;
    private Subscription subRateSP;
    private Subscription subRateFF;

    @Override
    public void init() {
        String spField;
        String[] p = this.param_Field_Pos_SP.get().split(" ");
        if (p.length > 1) {
            this.posSPAxis = "RPY".indexOf(p[0]);
            spField = p[1];
        } else {
            spField = p[0];
        }
        this.subPosSP = this.addSubscription(spField);
        this.subRateSP = this.addSubscription(this.param_Field_Rate_SP.get());
        this.subRateFF = this.addSubscription(this.param_Field_Rate_FF.get());
        this.pos = 0.0;
        this.rate = 0.0;
        this.posSP = 0.0;
        this.rateSP = 0.0;
        this.rateFF = 0.0;
        this.timePrev = -1.0;
        this.rateIntegral = 0.0;
        this.timeStep = this.param_Time_Step.get();
        this.delayLine.reset();
        this.delayLine.setDelay(this.param_Thrust_Delay.get());
        this.controlLPF.reset();
        this.controlLPF.setT(this.param_Thrust_T.get());
        this.outLPF.reset();
        this.outLPF.setT(this.param_Ctl_Out_T.get());
        this.rateLPF.setCutoffFreqFactor(this.param_Rate_LPF.get() * this.timeStep);
        this.addSeries("Rate");
        this.addSeries("Ctrl");
        this.addSeries("Acc");
        if (this.param_Use_Rate_SP.get().booleanValue()) {
            this.addSeries("Rate SP");
        } else {
            this.addSeries("Pos SP");
            this.addSeries("Pos");
        }
    }

    @Override
    public void process(double time) {
        if (this.timePrev < 0.0) {
            this.timePrev = time;
            return;
        }
        while (time > this.timePrev + this.timeStep) {
            this.timePrev += this.timeStep;
            this.updateSimulation(this.timePrev, this.timeStep);
        }
        this.updateSP();
    }

    private void updateSP() {
        if (this.param_Use_Rate_SP.get().booleanValue()) {
            Number rateSPNum = (Number)this.subRateSP.getValue();
            if (rateSPNum != null) {
                this.rateSP = rateSPNum.doubleValue();
            }
        } else {
            Object posSPObj;
            Number rateFFNum = (Number)this.subRateFF.getValue();
            if (rateFFNum != null) {
                this.rateFF = rateFFNum.doubleValue();
            }
            if ((posSPObj = this.subPosSP.getValue()) != null) {
                if (this.posSPAxis >= 0) {
                    for (int i = 0; i < 4; ++i) {
                        Object v = ((Object[])posSPObj)[i];
                        if (!(v instanceof Number)) {
                            return;
                        }
                        this.qArray[i] = ((Number)v).doubleValue();
                    }
                    double[] euler = RotationUtil.eulerAnglesByQuaternion(this.qArray);
                    this.posSP = euler[this.posSPAxis];
                } else if (posSPObj instanceof Number) {
                    this.posSP = ((Number)posSPObj).doubleValue();
                }
            }
        }
    }

    private double limitValue(double value, double limit) {
        if (limit == 0.0) {
            return value;
        }
        return Math.max(-limit, Math.min(limit, value));
    }

    private void updateSimulation(double time, double dt) {
        if (!this.param_Use_Rate_SP.get().booleanValue()) {
            double posErr = this.posSP - this.pos;
            this.rateSP = this.limitValue(this.param_Ctl_Pos_P.get() * posErr + this.param_Ctl_Rate_FF.get() * this.rateFF, this.param_Ctl_Rate_Limit.get());
        }
        double rateFiltered = this.rateLPF.apply(this.rate);
        double rateErr = this.rateSP - rateFiltered;
        double outFiltered = this.outLPF.getOutput();
        double control = this.param_Ctl_Rate_P.get() * rateErr;
        if (!Double.isFinite(control += this.param_Ctl_Rate_D.get() * (control - outFiltered))) {
            control = 0.0;
        }
        this.outLPF.apply(time, control);
        this.rateIntegral = this.limitValue(this.rateIntegral + this.param_Ctl_Rate_I.get() * this.outLPF.getOutput() * dt, this.param_Ctl_Rate_I_Limit.get());
        control += this.rateIntegral;
        control = this.limitValue(control, this.param_Ctl_Out_Limit.get());
        Double force = this.delayLine.getOutput(time, this.controlLPF.apply(time, control));
        if (force == null) {
            force = 0.0;
        }
        double acc = force * this.param_Thrust_K.get() - this.param_Drag.get() * Math.abs(this.rate) * this.rate;
        this.rate += acc * dt;
        this.pos += this.rate * dt;
        this.addPoint(0, time, this.rate);
        this.addPoint(1, time, control);
        if (this.param_Acc_Scale.get() != 0.0) {
            this.addPoint(2, time, acc * this.param_Acc_Scale.get());
        }
        if (this.param_Use_Rate_SP.get().booleanValue()) {
            this.addPoint(3, time, this.rateSP);
        } else {
            this.addPoint(3, time, this.posSP);
            this.addPoint(4, time, this.pos);
        }
    }
}

