/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.Subscription;
import com.microavia.jmalib.math.RotationUtil;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;

public class EulerFromQuaternion
extends PlotProcessor {
    protected Parameter<String> param_Field;
    protected Parameter<Double> param_Scale;
    protected Parameter<String> param_Show;
    protected Subscription subscription;
    private boolean[] show;
    private double[] qArray;

    public EulerFromQuaternion() {
        this.param_Field = new Parameter<String>(this.parameters, "Field", "ATTITUDE_POSITION.att_q");
        this.param_Scale = new Parameter<Double>(this.parameters, "Scale", 1.0);
        this.param_Show = new Parameter<String>(this.parameters, "Show", "RPY");
        this.qArray = new double[4];
    }

    @Override
    public void init() {
        this.subscription = this.addSubscription(this.param_Field.get());
        String showStr = this.param_Show.get().toUpperCase();
        this.show = new boolean[]{false, false, false};
        String[] axes = new String[]{"Roll", "Pitch", "Yaw"};
        for (int axis = 0; axis < 3; ++axis) {
            String axisName = axes[axis];
            this.show[axis] = showStr.contains(axisName.substring(0, 1));
            if (!this.show[axis]) continue;
            this.addSeries(axisName);
        }
    }

    @Override
    public void process(double time) {
        if (this.subscription.isUpdated()) {
            Object qNum = this.subscription.getValue();
            for (int i = 0; i < 4; ++i) {
                Object v = ((Object[])qNum)[i];
                if (!(v instanceof Number)) {
                    return;
                }
                this.qArray[i] = ((Number)v).doubleValue();
            }
            double[] euler = RotationUtil.eulerAnglesByQuaternion(this.qArray);
            int plot_idx = 0;
            for (int axis = 0; axis < 3; ++axis) {
                if (!this.show[axis]) continue;
                this.addPoint(plot_idx++, time, euler[axis] * this.param_Scale.get());
            }
        }
    }
}

