/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.jmalib.math.RotationUtil;
import com.microavia.plot.export.AbstractTrackExporter;
import com.microavia.plot.export.TrackPoint;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class KMLTrackExporter
extends AbstractTrackExporter {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    protected String getStyleForFlightMode(String flightMode) {
        switch (flightMode) {
            case "MANUAL": 
            case "ALTCTL": 
            case "POSCTL": 
            case "MISSION": 
            case "RTH": 
            case "ACRO": {
                return flightMode;
            }
        }
        return "DEFAULT";
    }

    @Override
    protected void writeStart() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<kml xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\">\n");
        this.writer.write("<Document>\n");
        this.writer.write("<name>" + this.title + "</name>\n");
        this.writer.write("<description></description>\n");
        this.writeStyle("DEFAULT", "ffffff");
        if (this.config.isSplitTracksByFlightMode()) {
            this.writeStyle("MANUAL", "ff0000");
            this.writeStyle("ALTCTL", "00ffff");
            this.writeStyle("POSCTL", "00ff00");
            this.writeStyle("MISSION", "ff00ff");
            this.writeStyle("RTH", "0000ff");
            this.writeStyle("ACRO", "ffff00");
        }
    }

    private void writeStyle(String name, String color) throws IOException {
        this.writer.write("<Style id=\"" + name + "\">\n");
        this.writer.write("  <LineStyle>\n");
        this.writer.write("    <width>2</width>\n");
        this.writer.write(String.format("    <color>a0%s</color>\n", color));
        this.writer.write("  </LineStyle>\n");
        this.writer.write("  <PolyStyle>\n");
        this.writer.write(String.format("    <color>60%s</color>\n", color));
        this.writer.write("  </PolyStyle>\n");
        this.writer.write("</Style>\n");
    }

    @Override
    protected void writeTrackPartStart(String trackPartName) throws IOException {
        String styleId = this.getStyleForFlightMode(this.flightMode);
        this.writer.write("<Placemark>\n");
        this.writer.write("<name>" + trackPartName + "</name>\n");
        this.writer.write("<description></description>\n");
        this.writer.write("<styleUrl>#" + styleId + "</styleUrl>\n");
        this.writer.write("<gx:Track id=\"" + trackPartName + "\">\n");
        this.writer.write("<altitudeMode>absolute</altitudeMode>\n");
        this.writer.write("<gx:interpolate>0</gx:interpolate>\n");
        this.writer.write("<extrude>1</extrude>\n");
    }

    @Override
    protected void writePoint(TrackPoint point) throws IOException {
        double[] euler = RotationUtil.eulerAnglesByQuaternion(point.attQ);
        this.writer.write(String.format("<when>%s</when>\n", this.dateFormatter.format(point.time / 1000L)));
        this.writer.write(String.format(Locale.ROOT, "<gx:coord>%.10f %.10f %.2f</gx:coord>\n", point.lon, point.lat, point.alt));
        this.writer.write(String.format(Locale.ROOT, "<gx:angles>%.2f %.2f %.2f</gx:angles>\n", euler[2], euler[1], euler[0]));
    }

    @Override
    protected void writeTrackPartEnd() throws IOException {
        this.writer.write("</gx:Track>\n");
        this.writer.write("</Placemark>\n");
    }

    @Override
    protected void writeEnd() throws IOException {
        this.writer.write("</Document>\n");
        this.writer.write("</kml>");
    }

    @Override
    public String getName() {
        return "KML";
    }

    @Override
    public String getDescription() {
        return "Google Earth Track (KML)";
    }

    @Override
    public String getFileExtension() {
        return "kml";
    }
}

