/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.plot.export.AbstractTrackExporter;
import com.microavia.plot.export.TrackPoint;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class GPXTrackExporter
extends AbstractTrackExporter {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    @Override
    protected void writeStart() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" version=\"1.1\" creator=\"Plot\" \n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n    xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">\n");
        this.writer.write("<metadata>\n");
        this.writer.write(String.format("<name>%s</name>\n", this.title));
        this.writer.write("</metadata>\n");
        this.writer.write("<trk>\n");
    }

    @Override
    protected void writeTrackPartStart(String trackPartName) throws IOException {
        this.writer.write("<trkseg>\n");
    }

    @Override
    protected void writePoint(TrackPoint point) throws IOException {
        this.writer.write(String.format(Locale.ROOT, "<trkpt lat=\"%.10f\" lon=\"%.10f\">\n", point.lat, point.lon));
        this.writer.write(String.format(Locale.ROOT, "<ele>%.2f</ele>\n", point.alt));
        this.writer.write(String.format("<time>%s</time>\n", this.dateFormatter.format(point.time / 1000L)));
        this.writer.write("</trkpt>\n");
    }

    @Override
    protected void writeTrackPartEnd() throws IOException {
        this.writer.write("</trkseg>\n");
    }

    @Override
    protected void writeEnd() throws IOException {
        this.writer.write("</trk>\n");
        this.writer.write("</gpx>\n");
    }

    @Override
    public String getName() {
        return "GPX";
    }

    @Override
    public String getDescription() {
        return "GPS Exchange Format (GPX)";
    }

    @Override
    public String getFileExtension() {
        return "gpx";
    }
}

