/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.math;

import java.util.Arrays;

public class RotationUtil {
    public static double[] rotationMatrixByEulerAngles(double roll, double pitch, double yaw) {
        return new double[]{Math.cos(pitch) * Math.cos(yaw), Math.sin(roll) * Math.sin(pitch) * Math.cos(yaw) - Math.cos(roll) * Math.sin(yaw), Math.cos(roll) * Math.sin(pitch) * Math.cos(yaw) + Math.sin(roll) * Math.sin(yaw), Math.cos(pitch) * Math.sin(yaw), Math.sin(roll) * Math.sin(pitch) * Math.sin(yaw) + Math.cos(roll) * Math.cos(yaw), Math.cos(roll) * Math.sin(pitch) * Math.sin(yaw) - Math.sin(roll) * Math.cos(yaw), -Math.sin(pitch), Math.sin(roll) * Math.cos(pitch), Math.cos(roll) * Math.cos(pitch)};
    }

    public static double[] quaternionByAngleAxis(double[] angleAxis) {
        double a = Math.sqrt(angleAxis[0] * angleAxis[0] + angleAxis[1] * angleAxis[1] + angleAxis[2] * angleAxis[2]);
        if (a > 1.0E-10) {
            double b = Math.sin(a / 2.0) / a;
            return new double[]{Math.cos(a / 2.0), angleAxis[0] * b, angleAxis[1] * b, angleAxis[2] * b};
        }
        return new double[]{1.0, 0.0, 0.0, 0.0};
    }

    public static double[] quaternionByEulerAngles(double roll, double pitch, double yaw) {
        double[] q = RotationUtil.quaternionByAngleAxis(new double[]{0.0, 0.0, yaw});
        q = RotationUtil.quaternionMult(RotationUtil.quaternionByAngleAxis(new double[]{0.0, pitch, 0.0}), q);
        return RotationUtil.quaternionMult(RotationUtil.quaternionByAngleAxis(new double[]{roll, 0.0, 0.0}), q);
    }

    public static double[] rotationMatrixByQuaternion(double[] q) {
        double aSq = q[0] * q[0];
        double bSq = q[1] * q[1];
        double cSq = q[2] * q[2];
        double dSq = q[3] * q[3];
        return new double[]{aSq + bSq - cSq - dSq, 2.0 * (q[1] * q[2] - q[0] * q[3]), 2.0 * (q[0] * q[2] + q[1] * q[3]), 2.0 * (q[1] * q[2] + q[0] * q[3]), aSq - bSq + cSq - dSq, 2.0 * (q[2] * q[3] - q[0] * q[1]), 2.0 * (q[1] * q[3] - q[0] * q[2]), 2.0 * (q[0] * q[1] + q[2] * q[3]), aSq - bSq - cSq + dSq};
    }

    public static double[] eulerAnglesByQuaternion(double[] q) {
        return new double[]{Math.atan2(2.0 * (q[0] * q[1] + q[2] * q[3]), 1.0 - 2.0 * (q[1] * q[1] + q[2] * q[2])), Math.asin(2.0 * (q[0] * q[2] - q[3] * q[1])), Math.atan2(2.0 * (q[0] * q[3] + q[1] * q[2]), 1.0 - 2.0 * (q[2] * q[2] + q[3] * q[3]))};
    }

    public static double[] rotateByQuaternion(double[] v, double[] q) {
        double[] qConj = new double[]{q[0], -q[1], -q[2], -q[3]};
        double[] qV = new double[]{0.0, v[0], v[1], v[2]};
        return Arrays.copyOfRange(RotationUtil.quaternionMult(RotationUtil.quaternionMult(q, qV), qConj), 1, 4);
    }

    public static double[] quaternionMult(double[] q1, double[] q2) {
        return new double[]{q1[0] * q2[0] - q1[1] * q2[1] - q1[2] * q2[2] - q1[3] * q2[3], q1[0] * q2[1] + q1[1] * q2[0] + q1[2] * q2[3] - q1[3] * q2[2], q1[0] * q2[2] + q1[2] * q2[0] + q1[3] * q2[1] - q1[1] * q2[3], q1[0] * q2[3] + q1[3] * q2[0] + q1[1] * q2[2] - q1[2] * q2[1]};
    }
}

