/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors.tools;

public class LowPassFilter {
    private boolean inited = false;
    private double value = 0.0;
    private double lastTime = Double.NaN;
    private double f = 1.0;
    private double rc_inv = this.f * 2.0 * Math.PI;

    public void setF(double f) {
        this.f = f;
        this.rc_inv = f * 2.0 * Math.PI;
    }

    public void setT(double t) {
        if (t == 0.0) {
            this.f = 0.0;
            this.rc_inv = 0.0;
        } else {
            this.setF(1.0 / t);
        }
    }

    public void reset() {
        this.inited = false;
        this.value = 0.0;
    }

    public double apply(double t, double sample) {
        if (this.rc_inv <= 0.0) {
            this.value = sample;
        } else {
            if (this.inited) {
                double dt = t - this.lastTime;
                this.value += (sample - this.value) * (1.0 - Math.exp(-dt * this.rc_inv));
            } else {
                this.value = sample;
                this.inited = true;
            }
            this.lastTime = t;
        }
        return this.value;
    }

    public double getOutput() {
        return this.value;
    }
}

