/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.Subscription;
import com.microavia.jmalib.math.RotationUtil;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;
import com.microavia.plot.processors.tools.ParseUtil;

public class NEDProjection
extends PlotProcessor {
    protected Parameter<String> param_Fields;
    protected Parameter<String> param_Field_Att;
    protected Parameter<Boolean> param_Reverse;
    protected Parameter<Double> param_Offset_Roll;
    protected Parameter<Double> param_Offset_Pitch;
    protected Parameter<Double> param_Offset_Yaw;
    private Subscription subVec;
    private Subscription subAtt;
    private double[] attQ;
    private double[] vec;
    private double[] offsQ;

    public NEDProjection() {
        this.param_Fields = new Parameter<String>(this.parameters, "Fields", "MAG_REPORT.value");
        this.param_Field_Att = new Parameter<String>(this.parameters, "Field Att", "ATTITUDE_POSITION.att_q");
        this.param_Reverse = new Parameter<Boolean>(this.parameters, "Reverse", false);
        this.param_Offset_Roll = new Parameter<Double>(this.parameters, "Offset Roll", 0.0);
        this.param_Offset_Pitch = new Parameter<Double>(this.parameters, "Offset Pitch", 0.0);
        this.param_Offset_Yaw = new Parameter<Double>(this.parameters, "Offset Yaw", 0.0);
        this.attQ = new double[]{1.0, 0.0, 0.0, 0.0};
        this.vec = new double[]{0.0, 0.0, 0.0};
        this.offsQ = new double[]{1.0, 0.0, 0.0, 0.0};
    }

    @Override
    public void init() {
        this.offsQ = RotationUtil.quaternionByEulerAngles(this.param_Offset_Roll.get() * Math.PI / 180.0, this.param_Offset_Pitch.get() * Math.PI / 180.0, this.param_Offset_Yaw.get() * Math.PI / 180.0);
        this.subVec = this.addSubscription(this.param_Fields.get());
        this.subAtt = this.addSubscription(this.param_Field_Att.get());
        this.addSeries("X");
        this.addSeries("Y");
        this.addSeries("Z");
    }

    @Override
    public void process(double time) {
        if (this.subAtt.isUpdated()) {
            ParseUtil.parseArray(this.subAtt.getValue(), this.attQ);
            if (this.param_Reverse.get().booleanValue()) {
                this.attQ[1] = -this.attQ[1];
                this.attQ[2] = -this.attQ[2];
                this.attQ[3] = -this.attQ[3];
            }
        }
        if (this.subVec.isUpdated() && ParseUtil.parseArray(this.subVec.getValue(), this.vec)) {
            double[] q = RotationUtil.quaternionMult(this.attQ, this.offsQ);
            double[] vecRot = RotationUtil.rotateByQuaternion(this.vec, q);
            this.addPoint(0, time, vecRot[0]);
            this.addPoint(1, time, vecRot[1]);
            this.addPoint(2, time, vecRot[2]);
        }
    }
}

