/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.Subscription;
import com.microavia.jmalib.math.GlobalPositionProjector;
import com.microavia.jmalib.math.LatLonAlt;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;

public class GlobalPositionProjection
extends PlotProcessor {
    protected Parameter<String> param_Fields;
    protected Parameter<String> param_Ref;
    private GlobalPositionProjector positionProjector;
    private String[] fields;
    private Subscription subLat;
    private Subscription subLon;

    public GlobalPositionProjection() {
        this.param_Fields = new Parameter<String>(this.parameters, "Fields", "ATTITUDE_POSITION.lat ATTITUDE_POSITION.lon");
        this.param_Ref = new Parameter<String>(this.parameters, "Ref Point", "");
        this.positionProjector = new GlobalPositionProjector();
    }

    @Override
    public void init() {
        this.positionProjector.reset();
        this.fields = this.param_Fields.get().split("[ \t]+");
        this.subLat = this.addSubscription(this.fields[0]);
        this.subLon = this.addSubscription(this.fields[1]);
        String[] ref = this.param_Ref.get().split("[ \t]+");
        if (ref.length >= 2) {
            this.positionProjector.init(new LatLonAlt(Double.parseDouble(ref[0]), Double.parseDouble(ref[1]), 0.0));
        }
        this.addSeries("N");
        this.addSeries("E");
    }

    @Override
    public void process(double time) {
        if (this.subLat.isUpdated() || this.subLon.isUpdated()) {
            Number latNum = (Number)this.subLat.getValue();
            Number lonNum = (Number)this.subLon.getValue();
            LatLonAlt latLonAlt = new LatLonAlt(latNum.doubleValue(), lonNum.doubleValue(), 0.0);
            if (!this.positionProjector.isInited()) {
                this.positionProjector.init(latLonAlt);
            }
            double[] ned = this.positionProjector.project(latLonAlt);
            this.addPoint(0, time, ned[0]);
            this.addPoint(1, time, ned[1]);
        }
    }
}

