/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.plot.processors.Simple;

public class Derivative
extends Simple {
    private double[] valuesPrev;
    private double[] timesPrev;

    @Override
    public void init() {
        super.init();
        this.valuesPrev = new double[this.fields.length];
        this.timesPrev = new double[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            this.valuesPrev[i] = Double.NaN;
            this.timesPrev[i] = Double.NaN;
        }
    }

    @Override
    protected double postProcessValue(int idx, double time, double in) {
        double dt;
        double out = Double.NaN;
        if (!Double.isNaN(this.timesPrev[idx]) && (dt = time - this.timesPrev[idx]) > 1.0E-5) {
            out = (in - this.valuesPrev[idx]) / dt;
        }
        this.valuesPrev[idx] = in;
        this.timesPrev[idx] = time;
        return out;
    }
}

