/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.jmalib.log.Subscription;
import com.microavia.plot.processors.Parameter;
import com.microavia.plot.processors.PlotProcessor;
import java.util.ArrayList;
import java.util.List;

public class Abs
extends PlotProcessor {
    protected Parameter<String> param_Fields;
    protected Parameter<Double> param_Scale;
    private List<Subscription> subscriptions;

    public Abs() {
        this.param_Fields = new Parameter<String>(this.parameters, "Fields", "ATTITUDE_POSITION.vel[0] ATTITUDE_POSITION.vel[1]");
        this.param_Scale = new Parameter<Double>(this.parameters, "Scale", 1.0);
        this.subscriptions = new ArrayList<Subscription>();
    }

    @Override
    public void init() {
        String[] fields;
        for (String field : fields = this.param_Fields.get().split("[ \t]+")) {
            this.subscriptions.add(this.addSubscription(field));
        }
        this.addSeries();
    }

    @Override
    public void process(double time) {
        double s = 0.0;
        for (Subscription sub : this.subscriptions) {
            Object v = sub.getValue();
            if (v instanceof Number) {
                double d = ((Number)v).doubleValue();
                s += d * d;
                continue;
            }
            if (!(v instanceof Object[])) continue;
            for (Object a : (Object[])v) {
                if (!(a instanceof Number)) continue;
                double d = ((Number)a).doubleValue();
                s += d * d;
            }
        }
        this.addPoint(0, time, Math.sqrt(s) * this.param_Scale.get());
    }
}

