/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.Subscription;
import com.microavia.jmalib.log.ulog.ULogReader;
import com.microavia.plot.export.AbstractTrackReader;
import com.microavia.plot.export.TrackPoint;
import com.microavia.plot.export.TrackReaderConfiguration;
import java.io.EOFException;
import java.io.IOException;

public class ULogTrackReader
extends AbstractTrackReader {
    private Subscription subPosValid;
    private Subscription subPosLat;
    private Subscription subPosLon;
    private Subscription subPosAltEl;
    private Subscription subUnd;
    private Subscription subAttQ;
    private Subscription subMode;

    ULogTrackReader(ULogReader reader, TrackReaderConfiguration config) throws IOException, FormatErrorException {
        super(reader, config);
        this.subPosValid = reader.addSubscription("ATTITUDE_POSITION.valid_pos");
        this.subPosLat = reader.addSubscription("ATTITUDE_POSITION.lat");
        this.subPosLon = reader.addSubscription("ATTITUDE_POSITION.lon");
        this.subPosAltEl = reader.addSubscription("ATTITUDE_POSITION.alt_el");
        this.subUnd = reader.addSubscription("ATTITUDE_POSITION.und");
        this.subAttQ = reader.addSubscription("ATTITUDE_POSITION.att_q");
        this.subMode = reader.addSubscription("SYSTEM_STATUS.mode");
    }

    @Override
    public TrackPoint readNextPoint() throws IOException {
        block4: {
            Number mode;
            long t;
            Object[] attQ;
            Number und;
            Number altEl;
            Number lon;
            Number lat;
            Number valid;
            do {
                try {
                    t = this.readUpdate();
                }
                catch (EOFException e) {
                    break block4;
                }
                valid = (Number)this.subPosValid.getValue();
                lat = (Number)this.subPosLat.getValue();
                lon = (Number)this.subPosLon.getValue();
                altEl = (Number)this.subPosAltEl.getValue();
                und = (Number)this.subUnd.getValue();
                attQ = (Object[])this.subAttQ.getValue();
                mode = (Number)this.subMode.getValue();
            } while (valid == null || lat == null || lon == null || altEl == null || und == null || attQ == null || valid.intValue() == 0);
            double[] attArr = new double[]{0.0, 0.0, 0.0, 1.0};
            for (int i = 0; i < 4; ++i) {
                Object v = attQ[i];
                if (!(v instanceof Number)) continue;
                attArr[i] = ((Number)v).doubleValue();
            }
            return new TrackPoint(lat.doubleValue(), lon.doubleValue(), altEl.doubleValue() + und.doubleValue() + this.config.getAltitudeOffset(), attArr, t + this.reader.getUTCTimeReferenceMicroseconds(), this.getFlightMode(mode));
        }
        return null;
    }

    private String getFlightMode(Number mode) {
        if (mode != null) {
            switch (mode.intValue()) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MANUAL";
                }
                case 2: {
                    return "ALTCTL";
                }
                case 3: {
                    return "POSCTL";
                }
                case 4: {
                    return "ACRO";
                }
                case 5: {
                    return "DESCEND";
                }
                case 6: {
                    return "LAND";
                }
                case 7: {
                    return "RTH";
                }
                case 8: {
                    return "MISSION";
                }
            }
            return String.format("UNKNOWN(%s)", mode.intValue());
        }
        return null;
    }
}

