/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.plot.PlotApp;
import com.microavia.plot.PreferencesUtil;
import com.microavia.plot.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.prefs.Preferences;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PlotExportDialog
extends JDialog {
    private static final String DIALOG_SETTING = "PlotExportDialog";
    private static final String LAST_EXPORT_DIRECTORY_SETTING = "LastExportDirectory";
    private JTextField widthField;
    private JTextField heightField;
    private JComboBox formatComboBox;
    private JTextField scaleField;
    private PlotApp app;
    private File lastExportDirectory;

    public PlotExportDialog(PlotApp app) {
        super((Frame)app, "Export Plot");
        this.app = app;
        this.createUIComponents();
        this.pack();
        this.setDefaultCloseOperation(1);
        this.getRootPane().registerKeyboardAction(e -> this.onClose(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onExport() {
        this.setVisible(false);
        String format = ((String)this.formatComboBox.getSelectedItem()).toLowerCase();
        JFileChooser fc = new JFileChooser();
        if (this.lastExportDirectory != null) {
            fc.setCurrentDirectory(this.lastExportDirectory);
        }
        FileNameExtensionFilter extensionFilter = new FileNameExtensionFilter(format.toUpperCase() + " Image (*." + format + ")", format);
        fc.setFileFilter(extensionFilter);
        fc.setDialogTitle("Export Plot");
        int returnVal = fc.showDialog(null, "Export Plot");
        if (returnVal == 0) {
            this.lastExportDirectory = fc.getCurrentDirectory();
            String fileName = fc.getSelectedFile().toString();
            if (extensionFilter == fc.getFileFilter() && !fileName.toLowerCase().endsWith("." + format)) {
                fileName = fileName + "." + format;
            }
            try {
                int width = Integer.parseInt(this.widthField.getText());
                int height = Integer.parseInt(this.heightField.getText());
                BufferedImage img = new BufferedImage(width, height, 1);
                Graphics2D g2 = img.createGraphics();
                double scale = Double.parseDouble(this.scaleField.getText());
                AffineTransform st = AffineTransform.getScaleInstance(scale, scale);
                g2.transform(st);
                this.app.getChart().draw(g2, new Rectangle2D.Double(0.0, 0.0, (double)width / scale, (double)height / scale), null, null);
                g2.dispose();
                ImageWriter imgWriter = ImageIO.getImageWritersByFormatName(format).next();
                ImageWriteParam imgWriteParam = imgWriter.getDefaultWriteParam();
                if ("jpg".equals(format)) {
                    imgWriteParam.setCompressionMode(2);
                    imgWriteParam.setCompressionQuality(1.0f);
                }
                FileImageOutputStream outputStream = new FileImageOutputStream(new File(fileName));
                imgWriter.setOutput(outputStream);
                IIOImage outputImage = new IIOImage(img, null, null);
                imgWriter.write(null, outputImage, imgWriteParam);
                imgWriter.dispose();
                this.app.setStatus(String.format("Exported to \"%s\"", fileName));
            }
            catch (Exception e) {
                this.app.setStatus("Error: " + e);
                e.printStackTrace();
            }
        }
        this.dispose();
    }

    private void onClose() {
        this.dispose();
    }

    public void savePreferences(Preferences preferences) {
        PreferencesUtil.saveWindowPreferences(this, preferences.node(DIALOG_SETTING));
        if (this.lastExportDirectory != null) {
            preferences.put(LAST_EXPORT_DIRECTORY_SETTING, this.lastExportDirectory.getAbsolutePath());
        }
    }

    public void loadPreferences(Preferences preferences) {
        PreferencesUtil.loadWindowPreferences(this, preferences.node(DIALOG_SETTING), -1, -1);
        String lastExportDirectoryPath = preferences.get(LAST_EXPORT_DIRECTORY_SETTING, null);
        if (null != lastExportDirectoryPath) {
            this.lastExportDirectory = new File(lastExportDirectoryPath);
        }
    }

    private void createUIComponents() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new SpringLayout());
        controlsPanel.add(new JLabel("Width"));
        this.widthField = new JTextField("1024");
        controlsPanel.add(this.widthField);
        controlsPanel.add(new JLabel("Height"));
        this.heightField = new JTextField("768");
        controlsPanel.add(this.heightField);
        controlsPanel.add(new JLabel("Format"));
        this.formatComboBox = new JComboBox<String>(new String[]{"PNG", "JPG"});
        controlsPanel.add(this.formatComboBox);
        controlsPanel.add(new JLabel("Scale"));
        this.scaleField = new JTextField("1.0");
        controlsPanel.add(this.scaleField);
        SpringUtilities.makeCompactGrid(controlsPanel, 4, 2, 5, 5, 5, 5);
        this.getContentPane().add((Component)controlsPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton buttonExport = new JButton("Export");
        buttonExport.addActionListener(e -> this.onExport());
        buttonsPanel.add(buttonExport);
        JButton buttonClose = new JButton("Close");
        buttonClose.addActionListener(e -> this.onClose());
        buttonsPanel.add(buttonClose);
        this.getContentPane().add((Component)buttonsPanel, "Last");
    }
}

