/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.plot.export.TrackExporter;
import com.microavia.plot.export.TrackExporterConfiguration;
import com.microavia.plot.export.TrackPoint;
import com.microavia.plot.export.TrackReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractTrackExporter
implements TrackExporter {
    private TrackReader trackReader;
    protected TrackExporterConfiguration config;
    protected String title;
    protected Writer writer;
    private int trackPart = 0;
    protected String flightMode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(TrackReader trackReader, TrackExporterConfiguration config, File file, String title) throws IOException {
        this.trackReader = trackReader;
        this.config = config;
        this.writer = new BufferedWriter(new FileWriter(file));
        this.title = title;
        this.trackPart = 0;
        boolean trackStarted = false;
        try {
            TrackPoint point;
            this.writeStart();
            while ((point = trackReader.readNextPoint()) != null) {
                if (!trackStarted || config.isSplitTracksByFlightMode() && point.flightMode != null && !point.flightMode.equals(this.flightMode)) {
                    String trackPartName;
                    if (trackStarted) {
                        this.writePoint(point);
                        this.writeTrackPartEnd();
                    }
                    this.flightMode = point.flightMode;
                    if (config.isSplitTracksByFlightMode() && point.flightMode != null) {
                        trackPartName = String.format("%s: %s", this.trackPart, point.flightMode);
                        ++this.trackPart;
                    } else {
                        trackPartName = "Track";
                    }
                    this.writeTrackPartStart(trackPartName);
                    trackStarted = true;
                }
                this.writePoint(point);
            }
            if (trackStarted) {
                this.writeTrackPartEnd();
            }
            this.writeEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.writer.close();
        }
    }

    protected abstract void writeStart() throws IOException;

    protected abstract void writeTrackPartStart(String var1) throws IOException;

    protected abstract void writePoint(TrackPoint var1) throws IOException;

    protected abstract void writeTrackPartEnd() throws IOException;

    protected abstract void writeEnd() throws IOException;
}

