/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.LogReader;
import com.microavia.jmalib.log.ulog.ULogReader;
import com.microavia.plot.ColorSupplier;
import com.microavia.plot.EditProcessorDialog;
import com.microavia.plot.FieldsListDialog;
import com.microavia.plot.LogInfo;
import com.microavia.plot.Marker;
import com.microavia.plot.MarkersList;
import com.microavia.plot.OSValidator;
import com.microavia.plot.ParametersPanel;
import com.microavia.plot.PlotItem;
import com.microavia.plot.PreferencesUtil;
import com.microavia.plot.Preset;
import com.microavia.plot.ProcessorPreset;
import com.microavia.plot.ProcessorsListPanel;
import com.microavia.plot.Series;
import com.microavia.plot.TaggedValueMarker;
import com.microavia.plot.XYPoint;
import com.microavia.plot.export.GPXTrackExporter;
import com.microavia.plot.export.KMLTrackExporter;
import com.microavia.plot.export.PlotExportDialog;
import com.microavia.plot.export.TrackExportDialog;
import com.microavia.plot.export.TrackExporter;
import com.microavia.plot.processors.PlotProcessor;
import com.microavia.plot.processors.ProcessorsList;
import com.microavia.plot.processors.Simple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.json.JSONObject;

public class PlotApp
extends JFrame {
    private static final int TIME_MODE_LOG_START = 0;
    private static final int TIME_MODE_BOOT = 1;
    private static final int TIME_MODE_GPS = 2;
    private static final String appName = "MicroAviaPlot";
    private final String appNameAndVersion;
    private final Preferences preferences;
    private JLabel statusLabel;
    private ProcessorsListPanel processorsListPanel;
    private ParametersPanel parametersPanel;
    private ChartPanel chartPanel;
    private JComboBox<Preset> presetComboBox;
    private final List<Preset> presetsList = new ArrayList<Preset>();
    private JCheckBox markerCheckBox;
    private JRadioButtonMenuItem[] timeModeItems;
    private LogReader logReader = null;
    private XYSeriesCollection dataset;
    private JFreeChart chart;
    private ColorSupplier colorSupplier;
    private final ProcessorsList processorsTypesList;
    private File lastPresetDirectory = null;
    private final EditProcessorDialog editProcessorDialog;
    private final FieldsListDialog fieldsListDialog;
    private final LogInfo logInfo;
    private final JFileChooser openLogFileChooser;
    private final FileNameExtensionFilter presetExtensionFilter = new FileNameExtensionFilter("Plot Presets (*.fplot)", "fplot");
    private final FileNameExtensionFilter parametersExtensionFilter = new FileNameExtensionFilter("Parameters (*.txt)", "txt");
    private final AtomicBoolean invokeProcessFile = new AtomicBoolean(false);
    private final TrackExportDialog trackExportDialog;
    private final PlotExportDialog plotExportDialog;
    private NumberAxis domainAxisSeconds;
    private DateAxis domainAxisDate;
    private int timeMode = 0;
    private final List<Map<String, Integer>> seriesIndex = new ArrayList<Map<String, Integer>>();
    private ProcessorPreset editingProcessor = null;
    private final List<ProcessorPreset> activeProcessors = new ArrayList<ProcessorPreset>();
    private Range lastTimeRange = null;
    private String currentPreset = null;

    private PlotApp() throws InstantiationException, IllegalAccessException {
        String version = this.getClass().getPackage().getImplementationVersion();
        this.appNameAndVersion = "MicroAviaPlot v." + version;
        this.setTitle(this.appNameAndVersion);
        LinkedHashMap<String, TrackExporter> exporters = new LinkedHashMap<String, TrackExporter>();
        for (TrackExporter exporter : new TrackExporter[]{new KMLTrackExporter(), new GPXTrackExporter()}) {
            exporters.put(exporter.getName(), exporter);
        }
        this.trackExportDialog = new TrackExportDialog(exporters);
        this.plotExportDialog = new PlotExportDialog(this);
        this.preferences = Preferences.userRoot().node(appName);
        this.processorsTypesList = new ProcessorsList();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PlotApp.this.onQuit();
            }
        });
        this.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (droppedFiles.size() == 1) {
                        File file = (File)droppedFiles.get(0);
                        PlotApp.this.openLog(file.getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.createUIComponents();
        ArrayList<String> processors = new ArrayList<String>(this.processorsTypesList.getProcessorsList());
        Collections.sort(processors);
        this.editProcessorDialog = new EditProcessorDialog(this, processors.toArray(new String[processors.size()]));
        this.fieldsListDialog = new FieldsListDialog(this);
        this.logInfo = new LogInfo(this);
        FileNameExtensionFilter[] logExtensionfilters = new FileNameExtensionFilter[]{new FileNameExtensionFilter("ULog (*.ulg)", "ulg")};
        this.openLogFileChooser = new JFileChooser();
        for (FileNameExtensionFilter filter : logExtensionfilters) {
            this.openLogFileChooser.addChoosableFileFilter(filter);
        }
        this.openLogFileChooser.setFileFilter(logExtensionfilters[0]);
        this.openLogFileChooser.setDialogTitle("Open Log");
        this.updatePresetEdited(true);
        this.pack();
        this.setVisible(true);
        try {
            this.loadPreferences();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            if (OSValidator.isMac()) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            try {
                new PlotApp();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    void addProcessor() {
        StringBuilder fieldsValue = new StringBuilder();
        for (String field : this.fieldsListDialog.getSelectedFields()) {
            if (fieldsValue.length() > 0) {
                fieldsValue.append(" ");
            }
            fieldsValue.append(field);
        }
        Simple processor = new Simple();
        processor.setParameters(Collections.singletonMap("Fields", fieldsValue.toString()));
        ProcessorPreset pp = new ProcessorPreset("New", processor.getProcessorType(), processor.getParameters(), Collections.emptyMap());
        this.updatePresetParameters(pp, null);
        this.processorsListPanel.addProcessor(pp, true);
        this.processorsListPanel.repaint();
        this.updateUsedColors();
        this.showAddProcessorDialog(true);
        this.processFile();
    }

    private void onQuit() {
        this.savePreferences();
        System.exit(0);
    }

    private void onPresetAction(ActionEvent e) {
        if ("comboBoxEdited".equals(e.getActionCommand())) {
            this.onSavePreset();
        } else if ("comboBoxChanged".equals(e.getActionCommand())) {
            String oldPreset = this.currentPreset;
            Object selection = this.presetComboBox.getSelectedItem();
            if (selection == null) {
                this.processorsListPanel.clearProcessors();
                this.updateUsedColors();
                this.currentPreset = null;
            } else if (selection instanceof Preset) {
                this.loadPreset((Preset)selection);
                this.currentPreset = ((Preset)selection).getTitle();
            }
            this.updatePresetEdited(false);
            if (this.currentPreset == null && oldPreset != null || this.currentPreset != null && !this.currentPreset.equals(oldPreset)) {
                this.processFile();
            }
        }
    }

    private void onSavePreset() {
        String presetTitle = this.presetComboBox.getSelectedItem().toString();
        if (presetTitle.isEmpty()) {
            this.setStatus("Enter preset name first");
            return;
        }
        Preset preset = this.formatPreset(presetTitle);
        boolean addNew = true;
        for (int i = 0; i < this.presetsList.size(); ++i) {
            if (!presetTitle.equals(this.presetsList.get(i).getTitle())) continue;
            addNew = false;
            this.presetsList.set(i, preset);
            this.setStatus("Preset \"" + preset.getTitle() + "\" updated");
            break;
        }
        if (addNew) {
            this.presetsList.add(preset);
            this.currentPreset = preset.getTitle();
            this.setStatus("Preset \"" + preset.getTitle() + "\" added");
        }
        this.loadPresetsList();
        this.updatePresetEdited(false);
        this.savePreferences();
    }

    private void onDeletePreset() {
        int i = this.presetComboBox.getSelectedIndex();
        Preset removedPreset = null;
        if (i > 0) {
            removedPreset = this.presetsList.remove(i - 1);
        }
        if (removedPreset != null) {
            this.loadPresetsList();
            this.setStatus("Preset \"" + removedPreset.getTitle() + "\" deleted");
            this.savePreferences();
        }
    }

    void updatePresetEdited(boolean edited) {
        this.presetComboBox.getEditor().getEditorComponent().setForeground(edited ? Color.GRAY : Color.BLACK);
    }

    private void loadPreferences() throws BackingStoreException {
        String presetDirectoryStr;
        PreferencesUtil.loadWindowPreferences(this, this.preferences.node("MainWindow"), 800, 600);
        PreferencesUtil.loadWindowPreferences(this.fieldsListDialog, this.preferences.node("FieldsListDialog"), 300, 600);
        PreferencesUtil.loadWindowPreferences(this.editProcessorDialog, this.preferences.node("AddProcessorDialog"), -1, -1);
        String logDirectoryStr = this.preferences.get("LogDirectory", null);
        if (logDirectoryStr != null) {
            File dir = new File(logDirectoryStr);
            this.openLogFileChooser.setCurrentDirectory(dir);
        }
        if ((presetDirectoryStr = this.preferences.get("PresetDirectory", null)) != null) {
            this.lastPresetDirectory = new File(presetDirectoryStr);
        }
        Preferences presets = this.preferences.node("Presets");
        this.presetsList.clear();
        for (String p : presets.keys()) {
            try {
                Preset preset = Preset.unpackJSONObject(new JSONObject(presets.get(p, "{}")));
                this.presetsList.add(preset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.loadPresetsList();
        this.timeMode = Integer.parseInt(this.preferences.get("TimeMode", "0"));
        this.timeModeItems[this.timeMode].setSelected(true);
        this.markerCheckBox.setSelected(this.preferences.getBoolean("ShowMarkers", false));
        this.trackExportDialog.loadPreferences(this.preferences);
        this.plotExportDialog.loadPreferences(this.preferences);
    }

    private void loadPresetsList() {
        Comparator presetComparator = (o1, o2) -> o1.getTitle().compareToIgnoreCase(o2.getTitle());
        this.presetsList.sort(presetComparator);
        this.presetComboBox.removeAllItems();
        this.presetComboBox.addItem(null);
        Preset selectPreset = null;
        for (Preset preset : this.presetsList) {
            this.presetComboBox.addItem(preset);
            if (!preset.getTitle().equals(this.currentPreset)) continue;
            selectPreset = preset;
        }
        this.presetComboBox.setSelectedItem(selectPreset);
    }

    private void savePreferences() {
        try {
            this.preferences.clear();
            for (String child : this.preferences.childrenNames()) {
                this.preferences.node(child).removeNode();
            }
            PreferencesUtil.saveWindowPreferences(this, this.preferences.node("MainWindow"));
            PreferencesUtil.saveWindowPreferences(this.fieldsListDialog, this.preferences.node("FieldsListDialog"));
            PreferencesUtil.saveWindowPreferences(this.editProcessorDialog, this.preferences.node("AddProcessorDialog"));
            File lastLogDirectory = this.openLogFileChooser.getCurrentDirectory();
            if (lastLogDirectory != null) {
                this.preferences.put("LogDirectory", lastLogDirectory.getAbsolutePath());
            }
            if (this.lastPresetDirectory != null) {
                this.preferences.put("PresetDirectory", this.lastPresetDirectory.getAbsolutePath());
            }
            Preferences presetsPref = this.preferences.node("Presets");
            for (int i = 0; i < this.presetComboBox.getItemCount(); ++i) {
                Preset object = this.presetComboBox.getItemAt(i);
                if (object == null) continue;
                Preset preset = object;
                try {
                    presetsPref.put(preset.getTitle(), preset.packJSONObject().toString());
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.preferences.put("TimeMode", Integer.toString(this.timeMode));
            this.preferences.putBoolean("ShowMarkers", this.markerCheckBox.isSelected());
            this.trackExportDialog.savePreferences(this.preferences);
            this.plotExportDialog.savePreferences(this.preferences);
            this.preferences.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private void loadPreset(Preset preset) {
        this.processorsListPanel.clearProcessors();
        for (ProcessorPreset pp : preset.getProcessorPresets()) {
            this.updatePresetParameters(pp, null);
            this.processorsListPanel.addProcessor(pp, false);
        }
        this.updateUsedColors();
    }

    private Preset formatPreset(String title) {
        ArrayList<ProcessorPreset> processorPresets = new ArrayList<ProcessorPreset>();
        for (int i = 0; i < this.processorsListPanel.getProcessorsCount(); ++i) {
            processorPresets.add(this.processorsListPanel.getProcessor(i).clone());
        }
        return new Preset(title, processorPresets);
    }

    private void createUIComponents() throws IllegalAccessException, InstantiationException {
        this.getContentPane().setLayout(new BorderLayout());
        this.createMenuBar();
        this.add((Component)this.createToolBar(), "First");
        this.processorsListPanel = new ProcessorsListPanel(this);
        this.parametersPanel = new ParametersPanel(this);
        this.chartPanel = this.createChartPanel();
        JSplitPane leftSplitPane = new JSplitPane(0, this.processorsListPanel, this.parametersPanel);
        leftSplitPane.setResizeWeight(0.5);
        JSplitPane mainSplitPane = new JSplitPane(1, leftSplitPane, this.chartPanel);
        mainSplitPane.setResizeWeight(0.25);
        this.add((Component)mainSplitPane, "Center");
        this.statusLabel = new JLabel(" ");
        this.add((Component)this.statusLabel, "Last");
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton openLogButton = new JButton("Open Log");
        openLogButton.addActionListener(e -> this.showOpenLogDialog());
        toolbar.add(openLogButton);
        JButton fieldsListButton = new JButton("Fields List");
        fieldsListButton.addActionListener(e -> this.fieldsListDialog.setVisible(true));
        toolbar.add(fieldsListButton);
        JButton logInfoButton = new JButton("Log Info");
        logInfoButton.addActionListener(e -> this.logInfo.setVisible(true));
        toolbar.add(logInfoButton);
        this.markerCheckBox = new JCheckBox("Markers");
        this.markerCheckBox.addActionListener(actionEvent -> this.setChartMarkers());
        toolbar.add(this.markerCheckBox);
        this.presetComboBox = new JComboBox();
        this.presetComboBox.setEditable(true);
        this.presetComboBox.setMaximumRowCount(30);
        this.presetComboBox.addActionListener(this::onPresetAction);
        toolbar.add(this.presetComboBox);
        JButton savePresetButton = new JButton("Save Preset");
        savePresetButton.addActionListener(e -> this.onSavePreset());
        toolbar.add(savePresetButton);
        JButton deletePresetButton = new JButton("Delete Preset");
        deletePresetButton.addActionListener(e -> this.onDeletePreset());
        toolbar.add(deletePresetButton);
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }

    private ChartPanel createChartPanel() {
        this.dataset = new XYSeriesCollection();
        this.colorSupplier = new ColorSupplier();
        this.chart = ChartFactory.createXYLineChart("", "", "", null, PlotOrientation.VERTICAL, true, true, false);
        this.chart.getXYPlot().setDataset(this.dataset);
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint(Color.WHITE);
        plot.setDomainGridlinePaint(Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint(Color.LIGHT_GRAY);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        plot.setRenderer(renderer);
        this.domainAxisSeconds = new NumberAxis("T"){

            @Override
            protected void autoAdjustRange() {
                this.setRange(this.getDefaultAutoRange());
            }
        };
        this.domainAxisSeconds.setLowerMargin(0.0);
        this.domainAxisSeconds.setUpperMargin(0.0);
        this.domainAxisDate = new DateAxis("T"){

            @Override
            protected void autoAdjustRange() {
                this.setRange(this.getDefaultAutoRange());
            }
        };
        this.domainAxisDate.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.domainAxisDate.setLowerMargin(0.0);
        this.domainAxisDate.setUpperMargin(0.0);
        plot.setDomainAxis(this.domainAxisSeconds);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        ChartPanel panel = new ChartPanel(this.chart, false);
        panel.setMouseWheelEnabled(true);
        panel.setMouseZoomable(true, false);
        panel.setPopupMenu(null);
        this.chart.addChangeListener(chartChangeEvent -> {
            Range timeRange;
            if (chartChangeEvent.getType() == ChartChangeEventType.GENERAL && !(timeRange = this.chart.getXYPlot().getDomainAxis().getRange()).equals(this.lastTimeRange)) {
                this.lastTimeRange = timeRange;
                this.processFile();
            }
        });
        return panel;
    }

    private void createMenuBar() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem fileOpenItem = new JMenuItem("Open Log...");
        fileOpenItem.addActionListener(e -> this.showOpenLogDialog());
        fileMenu.add(fileOpenItem);
        JMenuItem importPresetItem = new JMenuItem("Import Preset...");
        importPresetItem.addActionListener(e -> this.showImportPresetDialog());
        fileMenu.add(importPresetItem);
        JMenuItem exportPresetItem = new JMenuItem("Export Preset...");
        exportPresetItem.addActionListener(e -> this.showExportPresetDialog());
        fileMenu.add(exportPresetItem);
        JMenuItem exportAsImageItem = new JMenuItem("Export As Image...");
        exportAsImageItem.addActionListener(e -> this.showExportAsImageDialog());
        fileMenu.add(exportAsImageItem);
        JMenuItem exportTrackItem = new JMenuItem("Export Track...");
        exportTrackItem.addActionListener(e -> this.showExportTrackDialog());
        fileMenu.add(exportTrackItem);
        JMenuItem exportParametersItem = new JMenuItem("Export Parameters...");
        exportParametersItem.addActionListener(e -> this.showExportParametersDialog());
        fileMenu.add(exportParametersItem);
        if (!OSValidator.isMac()) {
            fileMenu.add(new JPopupMenu.Separator());
            JMenuItem exitItem = new JMenuItem("Exit");
            exitItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            exitItem.addActionListener(actionEvent -> this.onQuit());
            fileMenu.add(exitItem);
        }
        JMenu viewMenu = new JMenu("View");
        this.timeModeItems = new JRadioButtonMenuItem[3];
        this.timeModeItems[0] = new JRadioButtonMenuItem("Log Start Time");
        this.timeModeItems[1] = new JRadioButtonMenuItem("Boot Time");
        this.timeModeItems[2] = new JRadioButtonMenuItem("GPS Time");
        ButtonGroup timeModeGroup = new ButtonGroup();
        for (JRadioButtonMenuItem item : this.timeModeItems) {
            timeModeGroup.add(item);
            item.addActionListener(e -> {
                this.onTimeModeChanged();
                this.processFile();
            });
            viewMenu.add(item);
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        this.setJMenuBar(menuBar);
    }

    private void onTimeModeChanged() {
        int timeModeOld = this.timeMode;
        for (int i = 0; i < this.timeModeItems.length; ++i) {
            if (!this.timeModeItems[i].isSelected()) continue;
            this.timeMode = i;
            break;
        }
        long timeOffset = 0L;
        long logStart = 0L;
        long logSize = 1000000L;
        Range rangeOld = new Range(0.0, 1.0);
        if (this.logReader != null) {
            timeOffset = this.getTimeOffset(this.timeMode);
            logStart = this.logReader.getStartMicroseconds() + timeOffset;
            logSize = this.logReader.getSizeMicroseconds();
            rangeOld = this.getLogRange(timeModeOld);
        }
        ValueAxis domainAxis = this.selectDomainAxis(this.timeMode);
        this.chart.getXYPlot().setDomainAxis(0, domainAxis, false);
        if (domainAxis == this.domainAxisDate) {
            domainAxis.setRange(new Range(rangeOld.getLowerBound() * 1000.0 + (double)timeOffset * 0.001, rangeOld.getUpperBound() * 1000.0 + (double)timeOffset * 0.001), true, false);
            domainAxis.setDefaultAutoRange(new Range((double)logStart * 0.001, (double)(logStart + logSize) * 0.001));
        } else {
            domainAxis.setRange(new Range(rangeOld.getLowerBound() + (double)timeOffset * 1.0E-6, rangeOld.getUpperBound() + (double)timeOffset * 1.0E-6), true, false);
            domainAxis.setDefaultAutoRange(new Range((double)logStart * 1.0E-6, (double)(logStart + logSize) * 1.0E-6));
        }
    }

    private Range getLogRange(int tm) {
        Range range = this.selectDomainAxis(tm).getRange();
        if (tm == 2) {
            long timeOffset = this.getTimeOffset(tm);
            return new Range((range.getLowerBound() * 1000.0 - (double)timeOffset) * 1.0E-6, (range.getUpperBound() * 1000.0 - (double)timeOffset) * 1.0E-6);
        }
        long timeOffset = this.getTimeOffset(tm);
        return new Range(range.getLowerBound() - (double)timeOffset * 1.0E-6, range.getUpperBound() - (double)timeOffset * 1.0E-6);
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    private void showOpenLogDialog() {
        int returnVal = this.openLogFileChooser.showDialog(this, "Open");
        if (returnVal == 0) {
            File file = this.openLogFileChooser.getSelectedFile();
            String logFileName = file.getPath();
            this.openLog(logFileName);
        }
    }

    private void openLog(String logFileName) {
        ULogReader logReaderNew;
        String logFileNameLower = logFileName.toLowerCase();
        try {
            if (!logFileNameLower.endsWith(".ulg")) {
                this.setStatus("Log format not supported: " + logFileName);
                return;
            }
            logReaderNew = new ULogReader(logFileName);
        }
        catch (Exception e) {
            this.setStatus("Error: " + e);
            e.printStackTrace();
            return;
        }
        this.setTitle(this.appNameAndVersion + " - " + logFileName);
        if (this.logReader != null) {
            try {
                this.logReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.logReader = null;
        }
        this.logReader = logReaderNew;
        if (this.logReader.getErrors().size() > 0) {
            this.setStatus("Log file opened: " + logFileName + " (errors: " + this.logReader.getErrors().size() + ", see console output)");
            this.printLogErrors();
        } else {
            this.setStatus("Log file opened: " + logFileName);
        }
        this.logInfo.updateInfo(this.logReader);
        this.fieldsListDialog.setFieldsList(this.logReader.getFields());
        this.onTimeModeChanged();
        this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
        this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
        this.processFile();
    }

    private void showImportPresetDialog() {
        JFileChooser fc = new JFileChooser();
        if (this.lastPresetDirectory != null) {
            fc.setCurrentDirectory(this.lastPresetDirectory);
        }
        fc.setFileFilter(this.presetExtensionFilter);
        fc.setDialogTitle("Import Preset");
        int returnVal = fc.showDialog(this, "Import");
        if (returnVal == 0) {
            this.lastPresetDirectory = fc.getCurrentDirectory();
            File file = fc.getSelectedFile();
            try {
                int r;
                byte[] b = new byte[(int)file.length()];
                FileInputStream fileInputStream = new FileInputStream(file);
                for (int n = 0; n < b.length; n += r) {
                    r = fileInputStream.read(b, n, b.length - n);
                    if (r > 0) continue;
                    throw new Exception("Read error");
                }
                Preset preset = Preset.unpackJSONObject(new JSONObject(new String(b, StandardCharsets.UTF_8)));
                this.loadPreset(preset);
                this.processFile();
            }
            catch (Exception e) {
                this.setStatus("Error: " + e);
                e.printStackTrace();
            }
        }
    }

    private void showExportPresetDialog() {
        JFileChooser fc = new JFileChooser();
        if (this.lastPresetDirectory != null) {
            fc.setCurrentDirectory(this.lastPresetDirectory);
        }
        fc.setFileFilter(this.presetExtensionFilter);
        fc.setDialogTitle("Export Preset");
        int returnVal = fc.showDialog(this, "Export");
        if (returnVal == 0) {
            this.lastPresetDirectory = fc.getCurrentDirectory();
            String fileName = fc.getSelectedFile().toString();
            if (this.presetExtensionFilter == fc.getFileFilter() && !fileName.toLowerCase().endsWith(".fplot")) {
                fileName = fileName + ".fplot";
            }
            try {
                Object item = this.presetComboBox.getSelectedItem();
                String presetTitle = item == null ? "" : item.toString();
                Preset preset = this.formatPreset(presetTitle);
                FileWriter fileWriter = new FileWriter(new File(fileName));
                fileWriter.write(preset.packJSONObject().toString(1));
                fileWriter.close();
                this.setStatus("Preset saved to: " + fileName);
            }
            catch (Exception e) {
                this.setStatus("Error: " + e);
                e.printStackTrace();
            }
        }
    }

    private void showExportAsImageDialog() {
        if (this.logReader == null) {
            JOptionPane.showMessageDialog(this, "Log file must be opened first.", "Error", 0);
            return;
        }
        try {
            this.plotExportDialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showExportTrackStatusMessage("Track could not be exported.");
        }
    }

    private void showExportTrackDialog() {
        if (this.logReader == null) {
            JOptionPane.showMessageDialog(this, "Log file must be opened first.", "Error", 0);
            return;
        }
        try {
            this.trackExportDialog.display(this.logReader, this.getLogRange(this.timeMode));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showExportTrackStatusMessage("Track could not be exported.");
        }
    }

    private void showExportTrackStatusMessage(String message) {
        this.setStatus(String.format("Track export: %s", message));
    }

    void showExportParametersDialog() {
        if (this.logReader == null) {
            JOptionPane.showMessageDialog(this, "Log file must be opened first.", "Error", 0);
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(this.parametersExtensionFilter);
        fc.setDialogTitle("Export Parameters");
        int returnVal = fc.showDialog(this, "Export");
        if (returnVal == 0) {
            String fileName = fc.getSelectedFile().toString();
            if (this.parametersExtensionFilter == fc.getFileFilter() && !fileName.toLowerCase().endsWith(".txt")) {
                fileName = fileName + ".txt";
            }
            try {
                FileWriter fileWriter = new FileWriter(new File(fileName));
                ArrayList<Map.Entry<String, Object>> paramsList = new ArrayList<Map.Entry<String, Object>>(this.logReader.getParameters().entrySet());
                paramsList.sort(Comparator.comparing(Map.Entry::getKey));
                for (Map.Entry entry : paramsList) {
                    int typeID = 0;
                    Object value = entry.getValue();
                    if (value instanceof Float) {
                        typeID = 1;
                    }
                    fileWriter.write(String.format("%s\t%s\t%s\n", entry.getKey(), typeID, entry.getValue()));
                }
                fileWriter.close();
            }
            catch (Exception e) {
                this.setStatus("Error: " + e);
                e.printStackTrace();
            }
        }
    }

    void processFile() {
        if (this.logReader != null && this.invokeProcessFile.compareAndSet(false, true)) {
            boolean notEmptyPlot;
            boolean bl = notEmptyPlot = this.processorsListPanel.getActiveProcessors().size() > 0;
            if (notEmptyPlot) {
                this.setStatus("Processing...");
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    this.generateSeries();
                    if (notEmptyPlot) {
                        if (this.logReader.getErrors().size() > 0) {
                            this.setStatus("Log parsing errors, see console output");
                            this.printLogErrors();
                        } else {
                            this.setStatus(" ");
                        }
                    }
                }
                catch (Exception e) {
                    this.setStatus("Error: " + e);
                    e.printStackTrace();
                }
                this.invokeProcessFile.lazySet(false);
            });
        }
    }

    private void printLogErrors() {
        System.err.println("Log parsing errors:");
        int maxErrors = 100;
        for (Exception e : this.logReader.getErrors().subList(0, Math.min(this.logReader.getErrors().size(), maxErrors))) {
            System.err.println("\t" + e.getMessage());
        }
        if (this.logReader.getErrors().size() > maxErrors) {
            System.err.println("\t...");
        }
    }

    private long getTimeOffset(int tm) {
        long timeOffset = 0L;
        if (tm == 2) {
            timeOffset = this.logReader.getUTCTimeReferenceMicroseconds();
            if (timeOffset < 0L) {
                timeOffset = 0L;
            }
        } else if (tm == 0) {
            timeOffset = -this.logReader.getStartMicroseconds();
        }
        return timeOffset;
    }

    private ValueAxis selectDomainAxis(int tm) {
        if (tm == 2) {
            return this.domainAxisDate;
        }
        return this.domainAxisSeconds;
    }

    private void generateSeries() throws IOException, FormatErrorException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.activeProcessors.clear();
        this.activeProcessors.addAll(this.processorsListPanel.getActiveProcessors());
        this.dataset.removeAllSeries();
        this.seriesIndex.clear();
        PlotProcessor[] processors = new PlotProcessor[this.activeProcessors.size()];
        long timeOffset = this.getTimeOffset(this.timeMode);
        Range range = this.getLogRange(this.timeMode);
        long timeStart = (long)((range.getLowerBound() - range.getLength()) * 1000000.0);
        long timeStop = (long)((range.getUpperBound() + range.getLength()) * 1000000.0);
        timeStart = Math.max(this.logReader.getStartMicroseconds(), timeStart);
        timeStop = Math.min(this.logReader.getStartMicroseconds() + this.logReader.getSizeMicroseconds(), timeStop);
        double timeScale = this.selectDomainAxis(this.timeMode) == this.domainAxisDate ? 1000.0 : 1.0;
        this.logReader.removeAllSubscriptions();
        int displayPixels = 2000;
        double skip = range.getLength() / (double)displayPixels;
        if (processors.length > 0) {
            for (int i = 0; i < this.activeProcessors.size(); ++i) {
                ProcessorPreset pp = this.activeProcessors.get(i);
                PlotProcessor processor = this.processorsTypesList.getProcessorInstance(pp, skip, this.logReader.getFields());
                processor.setLogReader(this.logReader);
                processor.init();
                processor.setFieldsList(this.logReader.getFields());
                processors[i] = processor;
            }
            this.logReader.seek(timeStart);
            this.logReader.clearErrors();
            block3: while (true) {
                long t;
                try {
                    t = this.logReader.readUpdate();
                }
                catch (EOFException e) {
                    break;
                }
                if (t > timeStop) break;
                PlotProcessor[] e = processors;
                int n = e.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block3;
                    PlotProcessor processor = e[n2];
                    processor.process((double)(t + timeOffset) * 1.0E-6);
                    ++n2;
                }
                break;
            }
            this.chart.getXYPlot().clearDomainMarkers();
            for (int i = 0; i < this.activeProcessors.size(); ++i) {
                PlotProcessor processor = processors[i];
                String processorTitle = this.activeProcessors.get(i).getTitle();
                HashMap<String, Integer> processorSeriesIndex = new HashMap<String, Integer>();
                this.seriesIndex.add(processorSeriesIndex);
                for (PlotItem item : processor.getSeriesList()) {
                    XYSeries jseries;
                    if (item instanceof Series) {
                        Series series = (Series)item;
                        processorSeriesIndex.put(series.getTitle(), this.dataset.getSeriesCount());
                        jseries = new XYSeries((Comparable)((Object)series.getFullTitle(processorTitle)), false);
                        for (XYPoint point : series) {
                            jseries.add(point.x * timeScale, point.y, false);
                        }
                        this.dataset.addSeries(jseries);
                        continue;
                    }
                    if (!(item instanceof MarkersList)) continue;
                    MarkersList markers = (MarkersList)item;
                    processorSeriesIndex.put(markers.getTitle(), this.dataset.getSeriesCount());
                    jseries = new XYSeries((Comparable)((Object)markers.getFullTitle(processorTitle)), false);
                    this.dataset.addSeries(jseries);
                    for (Marker marker : markers) {
                        TaggedValueMarker m = new TaggedValueMarker(i, marker.x * timeScale);
                        m.setPaint(Color.black);
                        m.setLabel(marker.label);
                        m.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
                        m.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                        this.chart.getXYPlot().addDomainMarker(0, m, Layer.BACKGROUND, false);
                    }
                }
            }
            this.setChartColors();
            this.setChartMarkers();
        }
        this.chartPanel.repaint();
    }

    void setChartColors() {
        if (this.dataset.getSeriesCount() > 0) {
            Collection markers = this.chart.getXYPlot().getDomainMarkers(0, Layer.BACKGROUND);
            for (int i = 0; i < this.activeProcessors.size(); ++i) {
                for (Map.Entry<String, Integer> entry : this.seriesIndex.get(i).entrySet()) {
                    ProcessorPreset processorPreset = this.activeProcessors.get(i);
                    AbstractRenderer renderer = (AbstractRenderer)((Object)this.chart.getXYPlot().getRendererForDataset(this.dataset));
                    Paint color = processorPreset.getColors().get(entry.getKey());
                    renderer.setSeriesPaint(entry.getValue(), color, true);
                    if (markers == null) continue;
                    for (ValueMarker marker : markers) {
                        if (((TaggedValueMarker)marker).tag != i) continue;
                        marker.setPaint(color);
                    }
                }
            }
        }
    }

    private void setChartMarkers() {
        if (this.dataset.getSeriesCount() > 0) {
            boolean showMarkers = this.markerCheckBox.isSelected();
            Ellipse2D.Double marker = new Ellipse2D.Double(-1.5, -1.5, 3.0, 3.0);
            XYItemRenderer renderer = this.chart.getXYPlot().getRendererForDataset(this.dataset);
            if (renderer instanceof XYLineAndShapeRenderer) {
                for (int j = 0; j < this.dataset.getSeriesCount(); ++j) {
                    if (showMarkers) {
                        ((XYLineAndShapeRenderer)renderer).setSeriesShape(j, marker, false);
                    }
                    ((XYLineAndShapeRenderer)renderer).setSeriesShapesVisible(j, showMarkers);
                }
            }
        }
    }

    void showAddProcessorDialog(boolean editMode) {
        ProcessorPreset selectedProcessor = editMode ? this.processorsListPanel.getSelectedProcessor() : null;
        this.editProcessorDialog.display(selectedProcessor);
    }

    void onAddProcessorDialogOK() {
        this.processorsListPanel.repaint();
        this.updatePresetEdited(true);
        ProcessorPreset processorPreset = this.editProcessorDialog.getOrigProcessorPreset();
        String title = this.editProcessorDialog.getProcessorTitle();
        String processorType = this.editProcessorDialog.getProcessorType();
        if (processorPreset != null) {
            ProcessorPreset processorPresetNew = processorPreset;
            if (!processorPreset.getProcessorType().equals(processorType)) {
                Map<String, Object> parameters = processorPreset.getParameters();
                processorPresetNew = new ProcessorPreset(title, processorType, new HashMap<String, Object>(), Collections.emptyMap());
                this.updatePresetParameters(processorPresetNew, parameters);
                this.processorsListPanel.updateProcessor(processorPreset, processorPresetNew);
                this.onProcessorSelected();
            } else {
                processorPresetNew.setTitle(title);
            }
        } else {
            processorPreset = new ProcessorPreset(title, processorType, Collections.emptyMap(), Collections.emptyMap());
            this.updatePresetParameters(processorPreset, null);
            this.processorsListPanel.addProcessor(processorPreset, true);
        }
        this.updateUsedColors();
        this.processFile();
    }

    void updatePresetParameters(ProcessorPreset processorPreset, Map<String, Object> parametersUpdate) {
        PlotProcessor p;
        if (parametersUpdate != null) {
            processorPreset.getParameters().putAll(parametersUpdate);
        }
        try {
            p = this.processorsTypesList.getProcessorInstance(processorPreset, 0.0, null);
            p.init();
        }
        catch (Exception e) {
            this.setStatus("Error in processor \"" + processorPreset + "\"");
            e.printStackTrace();
            return;
        }
        processorPreset.setParameters(p.getParameters());
        HashMap<String, Color> colorsNew = new HashMap<String, Color>();
        for (PlotItem series : p.getSeriesList()) {
            Color color = processorPreset.getColors().get(series.getTitle());
            if (color == null) {
                color = this.colorSupplier.getNextColor(series.getTitle());
            }
            colorsNew.put(series.getTitle(), color);
        }
        processorPreset.setColors(colorsNew);
    }

    void updateUsedColors() {
        this.colorSupplier.resetColorsUsed();
        for (int i = 0; i < this.processorsListPanel.getProcessorsCount(); ++i) {
            ProcessorPreset pp = this.processorsListPanel.getProcessor(i);
            for (Color color : pp.getColors().values()) {
                this.colorSupplier.markColorUsed(color);
            }
        }
    }

    ColorSupplier getColorSupplier() {
        return this.colorSupplier;
    }

    void setEditingProcessor() {
        this.editingProcessor = this.processorsListPanel.getSelectedProcessor();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void onProcessorSelected() {
        this.parametersPanel.showProcessorParameters();
    }

    public ProcessorPreset getSelectedProcessor() {
        return this.processorsListPanel.getSelectedProcessor();
    }

    public ProcessorPreset getEditingProcessor() {
        return this.editingProcessor;
    }

    public void setEditingProcessor(ProcessorPreset p) {
        this.editingProcessor = p;
    }
}

