/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.PlotApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;

class FieldsListDialog
extends JDialog {
    private PlotApp app;
    private JTable fieldsTable;
    private DefaultTableModel fieldsTableModel;

    FieldsListDialog(PlotApp app) {
        super((Frame)app, "Fields List");
        this.app = app;
        this.createUIComponents();
        this.pack();
        this.setDefaultCloseOperation(1);
        this.getRootPane().registerKeyboardAction(e -> this.onClose(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onAdd() {
        this.app.addProcessor();
    }

    private void onClose() {
        this.setVisible(false);
    }

    void setFieldsList(Map<String, String> fields) {
        while (this.fieldsTableModel.getRowCount() > 0) {
            this.fieldsTableModel.removeRow(0);
        }
        ArrayList<String> fieldsList = new ArrayList<String>(fields.keySet());
        Collections.sort(fieldsList);
        for (String field : fieldsList) {
            this.fieldsTableModel.addRow(new Object[]{field, fields.get(field)});
        }
    }

    List<String> getSelectedFields() {
        ArrayList<String> selectedFields = new ArrayList<String>();
        for (int i : this.fieldsTable.getSelectedRows()) {
            selectedFields.add((String)this.fieldsTableModel.getValueAt(i, 0));
        }
        return selectedFields;
    }

    private void createUIComponents() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fieldsTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.fieldsTableModel.addColumn("Field");
        this.fieldsTableModel.addColumn("Type");
        this.fieldsTable = new JTable(this.fieldsTableModel);
        this.fieldsTable.registerKeyboardAction(e -> this.onAdd(), KeyStroke.getKeyStroke(10, 0), 1);
        this.getContentPane().add((Component)new JScrollPane(this.fieldsTable), "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton addButton = new JButton("Add");
        addButton.addActionListener(e -> this.onAdd());
        buttonsPanel.add(addButton);
        this.getRootPane().setDefaultButton(addButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(e -> this.setVisible(false));
        buttonsPanel.add(closeButton);
        this.getContentPane().add((Component)buttonsPanel, "Last");
    }
}

