/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log.ulog;

import com.microavia.jmalib.log.BinaryLogReader;
import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.Subscription;
import com.microavia.jmalib.log.ulog.AbstractParser;
import com.microavia.jmalib.log.ulog.ArrayParser;
import com.microavia.jmalib.log.ulog.FieldParser;
import com.microavia.jmalib.log.ulog.LogParserContext;
import com.microavia.jmalib.log.ulog.StructParser;
import com.microavia.jmalib.log.ulog.Topic;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ULogReader
extends BinaryLogReader {
    private static final byte SYNC_BYTE = 62;
    private static final byte MESSAGE_TYPE_STRUCT = 70;
    private static final byte MESSAGE_TYPE_TOPIC = 65;
    private static final byte MESSAGE_TYPE_DATA = 68;
    private static final byte MESSAGE_TYPE_INFO = 73;
    private static final byte MESSAGE_TYPE_PARAMETER = 80;
    private String systemName = "";
    private String systemConfig = "";
    private long dataStart = 0L;
    private Map<String, Topic> topicByName = new HashMap<String, Topic>();
    private Map<String, String> fieldsList = null;
    private Map<Integer, List<Subscription>> subscriptions = new HashMap<Integer, List<Subscription>>();
    private Set<Subscription> updatedSubscriptions = new HashSet<Subscription>();
    private long sizeUpdates = -1L;
    private long sizeMicroseconds = -1L;
    private long startMicroseconds = -1L;
    private long timeLast = Long.MIN_VALUE;
    private long utcTimeReference = -1L;
    private Map<String, Object> version = new HashMap<String, Object>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private List<Exception> errors = new ArrayList<Exception>();
    private int logVersion = 0;
    private int headerSize = 4;
    private int msgDataTimestampOffset = 3;
    private LogParserContext context = new LogParserContext();

    public ULogReader(String fileName) throws IOException, FormatErrorException {
        super(fileName);
        this.updateStatistics();
    }

    public static void main(String[] args) throws Exception {
        ULogReader reader = new ULogReader("test_long_v1.ulg");
        reader.addSubscription("ATTITUDE_POSITION.alt_baro");
        reader.seek(0L);
        long tStart = System.currentTimeMillis();
        try {
            block2: while (true) {
                long t = reader.readUpdate();
                Iterator<Subscription> iterator = reader.getUpdatedSubscriptions().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    Subscription s = iterator.next();
                    System.out.println(t + " " + s.getPath() + " " + s.getValue());
                }
                break;
            }
        }
        catch (EOFException t) {
            long tEnd = System.currentTimeMillis();
            for (Exception e : reader.getErrors()) {
                e.printStackTrace();
            }
            System.out.println(tEnd - tStart);
            reader.close();
            return;
        }
    }

    @Override
    public String getFormat() {
        return "ULog v" + this.logVersion;
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    @Override
    public String getSystemConfig() {
        return this.systemConfig;
    }

    @Override
    public long getSizeUpdates() {
        return this.sizeUpdates;
    }

    @Override
    public long getStartMicroseconds() {
        return this.startMicroseconds;
    }

    @Override
    public long getSizeMicroseconds() {
        return this.sizeMicroseconds;
    }

    @Override
    public long getUTCTimeReferenceMicroseconds() {
        return this.utcTimeReference;
    }

    @Override
    public Map<String, Object> getVersion() {
        return this.version;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    private void updateStatistics() throws IOException, FormatErrorException {
        this.position(0L);
        this.fillBuffer(4);
        byte[] logVersionBytes = new byte[4];
        this.buffer.get(logVersionBytes);
        String logVersionStr = new String(logVersionBytes, Charset.forName("latin1"));
        if (logVersionStr.startsWith("ULG")) {
            this.logVersion = Integer.parseInt(logVersionStr.substring(3));
            this.headerSize = 4;
            this.msgDataTimestampOffset = this.logVersion >= 2 ? 3 : 2;
        } else {
            throw new FormatErrorException("Unsupported file format");
        }
        this.startMicroseconds = -1L;
        this.sizeUpdates = 0L;
        this.fieldsList = new HashMap<String, String>();
        this.timeLast = Long.MIN_VALUE;
        try {
            while (true) {
                this.readMessage(this::handleHeaderMessage);
            }
        }
        catch (EOFException eOFException) {
            this.sizeMicroseconds = this.timeLast - this.startMicroseconds;
            this.seek(0L);
            return;
        }
    }

    @Override
    public Subscription addSubscription(String path) {
        String[] parts = path.split("\\.");
        Topic msg = null;
        int multiIdFilter = -1;
        AbstractParser parser = null;
        for (String p : parts) {
            String[] pp;
            if (msg == null) {
                pp = p.split("\\[");
                if (pp.length > 1) {
                    multiIdFilter = Integer.parseInt(pp[1].split("]")[0]);
                }
                msg = this.topicByName.get(pp[0]);
                parser = msg.getStruct();
                continue;
            }
            if (!(parser instanceof StructParser)) break;
            pp = p.split("\\[");
            if (pp.length > 1) {
                parser = ((StructParser)parser).get(pp[0]);
                try {
                    int idx = Integer.parseInt(pp[1].split("]")[0]);
                    if (!(parser instanceof ArrayParser)) continue;
                    parser = ((ArrayParser)parser).get(idx);
                }
                catch (Exception exception) {}
                continue;
            }
            parser = ((StructParser)parser).get(p);
        }
        if (msg != null && parser != null) {
            Subscription subscription = new Subscription(path, parser, multiIdFilter);
            this.subscriptions.putIfAbsent(msg.getId(), new ArrayList());
            this.subscriptions.get(msg.getId()).add(subscription);
            return subscription;
        }
        return new Subscription(path, null, -1);
    }

    @Override
    public void removeAllSubscriptions() {
        this.subscriptions.clear();
        this.updatedSubscriptions.clear();
    }

    @Override
    public long readUpdate() throws IOException {
        this.updatedSubscriptions.clear();
        this.timeLast = Long.MIN_VALUE;
        do {
            this.readMessage(this::handleDataMessage);
        } while (this.timeLast == Long.MIN_VALUE);
        return this.timeLast;
    }

    @Override
    public Set<Subscription> getUpdatedSubscriptions() {
        return this.updatedSubscriptions;
    }

    @Override
    public boolean seek(long seekTime) throws IOException {
        this.position(this.dataStart);
        this.timeLast = Long.MIN_VALUE;
        if (seekTime == 0L) {
            return true;
        }
        try {
            while (this.timeLast < seekTime) {
                this.readMessage((pos, msgType, msgSize) -> {
                    if (msgType == 68) {
                        this.timeLast = this.buffer.getLong(this.buffer.position() + this.msgDataTimestampOffset);
                        if (this.timeLast >= seekTime) {
                            this.position(pos);
                            return;
                        }
                    }
                    this.buffer.position(this.buffer.position() + msgSize);
                });
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    @Override
    public Map<String, String> getFields() {
        return this.fieldsList;
    }

    private void readMessage(MessageHandler handler) throws IOException {
        long pos;
        while (true) {
            this.fillBuffer(this.headerSize);
            pos = this.position();
            byte sync = this.buffer.get();
            if (sync == 62) break;
            this.errors.add(new FormatErrorException(pos, String.format("Wrong sync byte: 0x%02X (expected 0x%02X)", sync & 0xFF, 62)));
        }
        int msgType = this.buffer.get() & 0xFF;
        int msgSize = this.buffer.getShort() & 0xFFFF;
        try {
            this.fillBuffer(msgSize);
        }
        catch (EOFException e) {
            this.errors.add(new FormatErrorException(pos, "Unexpected end of file"));
            throw e;
        }
        try {
            handler.handleMessage(pos, msgType, msgSize);
        }
        catch (Exception e) {
            this.errors.add(new FormatErrorException(pos, "Error parsing message type: " + msgType, e));
        }
    }

    private void handleHeaderMessage(long pos, int msgType, int msgSize) throws IOException {
        switch (msgType) {
            case 68: {
                if (this.dataStart == 0L) {
                    this.dataStart = pos;
                }
                long timestamp = this.buffer.getLong(this.buffer.position() + this.msgDataTimestampOffset);
                if (this.startMicroseconds < 0L) {
                    this.startMicroseconds = timestamp;
                }
                this.timeLast = timestamp;
                ++this.sizeUpdates;
                this.buffer.position(this.buffer.position() + msgSize);
                break;
            }
            case 70: {
                if (this.logVersion <= 1) {
                    int msgId = this.buffer.get() & 0xFF;
                    int formatLen = this.buffer.getShort() & 0xFFFF;
                    String[] descr = this.getString(this.buffer, formatLen).split(":");
                    String name = descr[0];
                    if (descr.length <= 1) break;
                    StructParser struct = null;
                    try {
                        struct = new StructParser(this.context, descr[1]);
                    }
                    catch (FormatErrorException e) {
                        this.errors.add(new FormatErrorException(pos, String.format("Error parsing type definition: %s", e.toString()), e));
                        break;
                    }
                    this.context.getStructs().put(name, struct);
                    this.topicByName.put(name, new Topic(name, struct, msgId));
                    this.addFieldsToList(name, struct);
                    break;
                }
                String[] descr = this.getString(this.buffer, msgSize).split(":");
                String name = descr[0];
                if (descr.length <= 1) break;
                StructParser struct = null;
                try {
                    struct = new StructParser(this.context, descr[1]);
                }
                catch (Exception e) {
                    this.errors.add(new FormatErrorException(pos, String.format("Error parsing struct: %s", e.toString()), e));
                    break;
                }
                this.context.getStructs().put(name, struct);
                break;
            }
            case 65: {
                int msgId = this.buffer.getShort() & 0xFFFF;
                String[] descr = this.getString(this.buffer, msgSize - 2).split(":");
                String name = descr[0];
                String structName = descr[1];
                StructParser struct = this.context.getStructs().get(structName);
                Topic topic = new Topic(name, struct, msgId);
                this.topicByName.put(name, topic);
                this.addFieldsToList(name, struct);
                break;
            }
            case 73: {
                int keyLen = this.buffer.get() & 0xFF;
                String[] keyDescr = this.getString(this.buffer, keyLen).split(" ");
                String key = keyDescr[1];
                AbstractParser field = null;
                try {
                    field = AbstractParser.createFromFormatString(this.context, keyDescr[0]);
                }
                catch (FormatErrorException e) {
                    this.errors.add(new FormatErrorException(pos, "Error parsing info", e));
                    break;
                }
                Object value = field.parse(this.buffer);
                this.buffer.position(this.buffer.position() + field.size());
                switch (key) {
                    case "sys_name": {
                        this.systemName = (String)value;
                        break;
                    }
                    case "sys_config": {
                        this.systemConfig = (String)value;
                        break;
                    }
                    case "ver_hw": {
                        this.version.put("HW", value);
                        break;
                    }
                    case "ver_sw": {
                        this.version.put("FW", value);
                        break;
                    }
                    case "time_ref_utc": {
                        this.utcTimeReference = ((Number)value).longValue();
                    }
                }
                break;
            }
            case 80: {
                int keyLen = this.buffer.get() & 0xFF;
                String[] keyDescr = this.getString(this.buffer, keyLen).split(" ");
                String key = keyDescr[1];
                AbstractParser field = null;
                try {
                    field = AbstractParser.createFromFormatString(this.context, keyDescr[0]);
                }
                catch (FormatErrorException e) {
                    this.errors.add(new FormatErrorException(pos, "Error parsing parameter", e));
                    break;
                }
                Object value = field.parse(this.buffer);
                this.buffer.position(this.buffer.position() + field.size());
                this.parameters.put(key, value);
                break;
            }
            default: {
                this.buffer.position(this.buffer.position() + msgSize);
                this.errors.add(new FormatErrorException(pos, "Unknown message type: " + msgType));
            }
        }
        int sizeParsed = (int)(this.position() - pos - (long)this.headerSize);
        if (sizeParsed != msgSize) {
            this.errors.add(new FormatErrorException(pos, "Message size mismatch, parsed: " + sizeParsed + ", msg size: " + msgSize + ", msgType: " + msgType));
            this.buffer.position(this.buffer.position() + msgSize - sizeParsed);
        }
    }

    private void addFieldsToList(String path, AbstractParser value) {
        block3: {
            block4: {
                block2: {
                    if (!(value instanceof FieldParser)) break block2;
                    this.fieldsList.put(path, ((FieldParser)value).getType());
                    break block3;
                }
                if (!(value instanceof ArrayParser)) break block4;
                AbstractParser[] items = ((ArrayParser)value).getItems();
                for (int i = 0; i < items.length; ++i) {
                    AbstractParser item = items[i];
                    this.addFieldsToList(String.format("%s[%s]", path, i), item);
                }
                break block3;
            }
            if (!(value instanceof StructParser)) break block3;
            for (Map.Entry<String, AbstractParser> e : ((StructParser)value).getFields().entrySet()) {
                if (e.getKey().startsWith("_")) continue;
                this.addFieldsToList(String.format("%s.%s", path, e.getKey()), e.getValue());
            }
        }
    }

    private void handleDataMessage(long pos, int msgType, int msgSize) {
        int bp = this.buffer.position();
        if (msgType == 68) {
            int msgId = this.logVersion >= 2 ? this.buffer.getShort() & 0xFFFF : this.buffer.get() & 0xFF;
            List<Subscription> subs = this.subscriptions.get(msgId);
            if (subs != null) {
                int multiId = this.buffer.get() & 0xFF;
                long timestamp = this.buffer.getLong();
                for (Subscription sub : subs) {
                    if (!sub.update(this.buffer, multiId)) continue;
                    this.updatedSubscriptions.add(sub);
                    this.timeLast = timestamp;
                }
            }
        } else {
            this.errors.add(new FormatErrorException("Unexpected message type: " + msgType));
        }
        this.buffer.position(bp + msgSize);
    }

    private String getString(ByteBuffer buffer, int len) {
        byte[] strBuf = new byte[len];
        buffer.get(strBuf);
        String[] p = new String(strBuf, this.context.getCharset()).split("\u0000");
        return p.length > 0 ? p[0] : "";
    }

    @Override
    public List<Exception> getErrors() {
        return this.errors;
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    static interface MessageHandler {
        public void handleMessage(long var1, int var3, int var4) throws IOException;
    }
}

