/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log.ulog;

import com.microavia.jmalib.log.ulog.AbstractParser;
import com.microavia.jmalib.log.ulog.LogParserContext;
import java.nio.ByteBuffer;

class ArrayParser
extends AbstractParser {
    private final LogParserContext context;
    private final AbstractParser[] items;

    ArrayParser(LogParserContext context, AbstractParser itemType, int arraySize) {
        super(context);
        this.context = context;
        this.size = itemType.size() * arraySize;
        this.items = new AbstractParser[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            this.items[i] = itemType.clone();
        }
        this.setOffset(0);
    }

    AbstractParser[] getItems() {
        return this.items;
    }

    AbstractParser get(int idx) {
        return this.items[idx];
    }

    @Override
    public AbstractParser clone() {
        return new ArrayParser(this.context, this.items[0], this.items.length);
    }

    @Override
    public void setOffset(int offset) {
        for (AbstractParser item : this.items) {
            item.setOffset(offset);
            offset += item.size();
        }
    }

    @Override
    public Object parse(ByteBuffer buffer) {
        Object[] v = new Object[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            v[i] = this.items[i].parse(buffer);
        }
        return v;
    }

    public String toString() {
        return String.format("%s[%s]", this.items[0].toString(), this.items.length);
    }
}

