/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log;

import com.microavia.jmalib.log.LogReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public abstract class BinaryLogReader
implements LogReader {
    protected ByteBuffer buffer = ByteBuffer.allocate(8192);
    private FileChannel channel;
    private long channelPosition = 0L;

    public BinaryLogReader(String fileName) throws IOException {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.flip();
        this.channel = new RandomAccessFile(fileName, "r").getChannel();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.channel = null;
    }

    public int fillBuffer() throws IOException {
        this.buffer.compact();
        int n = this.channel.read(this.buffer);
        this.buffer.flip();
        if (n < 0) {
            throw new EOFException();
        }
        this.channelPosition += (long)n;
        return n;
    }

    protected void fillBuffer(int required) throws IOException {
        if (this.buffer.remaining() < required) {
            this.buffer.compact();
            int n = this.channel.read(this.buffer);
            this.buffer.flip();
            if (n < 0 || this.buffer.remaining() < required) {
                throw new EOFException();
            }
            this.channelPosition += (long)n;
        }
    }

    protected long position() {
        return this.channelPosition - (long)this.buffer.remaining();
    }

    protected void position(long pos) throws IOException {
        this.buffer.clear();
        this.channel.position(pos);
        this.channelPosition = pos;
        int n = this.channel.read(this.buffer);
        this.buffer.flip();
        if (n < 0) {
            throw new EOFException();
        }
        this.channelPosition += (long)n;
    }
}

