/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors.tools;

public class PID {
    private double kP = 0.0;
    private double kI = 0.0;
    private double kD = 0.0;
    private double limit = 0.0;
    private double integral = 0.0;
    private double errorLast = 0.0;
    private MODE mode = MODE.DERIVATIVE_CALC;

    public void setK(double kP, double kI, double kD, double limit, MODE mode) {
        this.kP = kP;
        this.kI = kI;
        this.kD = kD;
        this.limit = limit;
        this.mode = mode;
    }

    public void reset() {
        this.errorLast = 0.0;
        this.integral = 0.0;
    }

    public double getIntegral() {
        return this.integral;
    }

    public void setIntegral(double integral) {
        this.integral = integral;
    }

    private double limitValue(double value) {
        if (this.limit == 0.0) {
            return value;
        }
        return Math.max(-this.limit, Math.min(this.limit, value));
    }

    public double getOutput(double err, double dt) {
        if (this.mode != MODE.DERIVATIVE_CALC) {
            throw new RuntimeException("Can't use this method in mode " + (Object)((Object)this.mode));
        }
        double d = (err - this.errorLast) / dt;
        this.errorLast = err;
        double pd = err * this.kP + d * this.kD;
        this.integral += pd / this.kP * this.kI * dt;
        this.integral = this.limitValue(this.integral);
        return this.limitValue(pd + this.integral);
    }

    public double getOutput(double err, double derivative, double dt) {
        if (this.mode != MODE.DERIVATIVE_SET) {
            throw new RuntimeException("Can't use this method in mode " + (Object)((Object)this.mode));
        }
        this.errorLast = err;
        double pd = err * this.kP + derivative * this.kD;
        this.integral += pd / this.kP * this.kI * dt;
        this.integral = this.limitValue(this.integral);
        return this.limitValue(pd + this.integral);
    }

    public double getOutput(double sp, double value, double derivative, double dt, double awuW) {
        double d;
        double err = sp - value;
        if (this.mode == MODE.DERIVATIVE_SET) {
            d = derivative;
            this.errorLast = err;
        } else if (this.mode == MODE.DERIVATIVE_CALC) {
            d = (err - this.errorLast) / dt;
            this.errorLast = err;
        } else if (this.mode == MODE.DERIVATIVE_CALC_NO_SP) {
            d = (-value - this.errorLast) / dt;
            this.errorLast = -value;
        } else {
            d = 0.0;
            this.errorLast = 0.0;
        }
        double pd = err * this.kP + d * this.kD;
        double i = this.integral + err * this.kI * dt * awuW;
        if (this.limit == 0.0 || Math.abs(i) < this.limit && Math.abs(pd + i) < this.limit) {
            this.integral = this.limitValue(i);
        }
        return this.limitValue(pd + this.integral);
    }

    public static enum MODE {
        DERIVATIVE_SET,
        DERIVATIVE_CALC,
        DERIVATIVE_CALC_NO_SP;

    }
}

