/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors.tools;

import java.util.LinkedList;
import java.util.List;

public class DelayLine<T> {
    private double delay = 0.0;
    private List<Tick<T>> buffer = new LinkedList<Tick<T>>();
    T value = null;

    public void reset() {
        this.buffer.clear();
        this.value = null;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double delay) {
        this.delay = delay;
    }

    public T getOutput(double time) {
        while (!this.buffer.isEmpty()) {
            Tick<T> tick = this.buffer.get(0);
            if (time - tick.time < this.delay) break;
            this.value = tick.value;
            this.buffer.remove(0);
        }
        return this.value;
    }

    public T getOutput(double time, T in) {
        this.buffer.add(new Tick<T>(time, in));
        return this.getOutput(time);
    }

    public static class Tick<V> {
        public final double time;
        public final V value;

        public Tick(double time, V value) {
            this.time = time;
            this.value = value;
        }
    }
}

