/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.processors;

import com.microavia.plot.ProcessorPreset;
import com.microavia.plot.processors.ATan2;
import com.microavia.plot.processors.Abs;
import com.microavia.plot.processors.Derivative;
import com.microavia.plot.processors.EulerFromQuaternion;
import com.microavia.plot.processors.GlobalPositionProjection;
import com.microavia.plot.processors.Integral;
import com.microavia.plot.processors.NEDProjection;
import com.microavia.plot.processors.PlotProcessor;
import com.microavia.plot.processors.PosRatePIDControlSimulator;
import com.microavia.plot.processors.Simple;
import com.microavia.plot.processors.Text;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProcessorsList {
    private Map<String, Class<? extends PlotProcessor>> processors = new HashMap<String, Class<? extends PlotProcessor>>();

    public ProcessorsList() throws InstantiationException, IllegalAccessException {
        this.addProcessorClass(Simple.class);
        this.addProcessorClass(Derivative.class);
        this.addProcessorClass(Abs.class);
        this.addProcessorClass(ATan2.class);
        this.addProcessorClass(PosRatePIDControlSimulator.class);
        this.addProcessorClass(GlobalPositionProjection.class);
        this.addProcessorClass(NEDProjection.class);
        this.addProcessorClass(Integral.class);
        this.addProcessorClass(EulerFromQuaternion.class);
        this.addProcessorClass(Text.class);
    }

    private void addProcessorClass(Class<? extends PlotProcessor> processorClass) {
        this.processors.put(processorClass.getSimpleName(), processorClass);
    }

    public Set<String> getProcessorsList() {
        return this.processors.keySet();
    }

    public PlotProcessor getProcessorInstance(ProcessorPreset processorPreset, double skipOut, Map<String, String> fieldsList) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<? extends PlotProcessor> procClass = this.processors.get(processorPreset.getProcessorType());
        if (procClass != null) {
            PlotProcessor processor = procClass.newInstance();
            processor.setSkipOut(skipOut);
            processor.setFieldsList(fieldsList);
            processor.setParameters(processorPreset.getParameters());
            return processor;
        }
        return null;
    }
}

