/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot.export;

import com.microavia.jmalib.log.LogReader;
import com.microavia.plot.PreferencesUtil;
import com.microavia.plot.SpringUtilities;
import com.microavia.plot.export.TrackExporter;
import com.microavia.plot.export.TrackExporterConfiguration;
import com.microavia.plot.export.TrackReader;
import com.microavia.plot.export.TrackReaderConfiguration;
import com.microavia.plot.export.TrackReaderFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.data.Range;

public class TrackExportDialog
extends JDialog {
    private static final String DIALOG_SETTING = "TrackExportDialog";
    private static final String EXPORTER_CONFIGURATION_SETTING = "ExporterConfiguration";
    private static final String READER_CONFIGURATION_SETTING = "ReaderConfiguration";
    private static final String LAST_EXPORT_DIRECTORY_SETTING = "LastExportDirectory";
    private JButton buttonExport;
    private JCheckBox splitTrackByFlightCheckBox;
    private JComboBox exportFormatComboBox;
    private JSlider samplesPerSecond;
    private JLabel samplesPerSecondValue;
    private JLabel logEndTimeValue;
    private JTextField timeEndField;
    private JTextField timeStartField;
    private JLabel timeStartLabel;
    private JLabel timeEndLabel;
    private JTextField altOffsetField;
    private JLabel statusLabel;
    private JCheckBox exportDataInChartCheckBox;
    private File lastExportDirectory;
    private Map<String, TrackExporter> exporters;
    private TrackExporterConfiguration exporterConfiguration = new TrackExporterConfiguration();
    private TrackReaderConfiguration readerConfiguration = new TrackReaderConfiguration();
    private LogReader logReader;
    private Range chartRange;

    public TrackExportDialog(Map<String, TrackExporter> exporters) {
        this.exporters = exporters;
        this.setModal(true);
        this.setTitle("Export settings");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel formatPanel = new JPanel(new BorderLayout());
        formatPanel.setBorder(BorderFactory.createTitledBorder("Format"));
        this.exportFormatComboBox = new JComboBox();
        formatPanel.add((Component)new JLabel("Export format"), "Before");
        formatPanel.add((Component)this.exportFormatComboBox, "Center");
        this.splitTrackByFlightCheckBox = new JCheckBox("Split track by flight mode");
        formatPanel.add((Component)this.splitTrackByFlightCheckBox, "Last");
        formatPanel.setAlignmentX(0.0f);
        this.add(formatPanel);
        JPanel timePanel = new JPanel(new SpringLayout());
        timePanel.setBorder(BorderFactory.createTitledBorder("Time range"));
        timePanel.add(new JLabel("Samples per second"));
        this.samplesPerSecond = new JSlider(0, 1, 20, 10);
        this.samplesPerSecond.setPreferredSize(new Dimension(150, this.samplesPerSecond.getPreferredSize().height));
        this.samplesPerSecond.setMinimumSize(this.samplesPerSecond.getPreferredSize());
        this.samplesPerSecond.setMinorTickSpacing(1);
        this.samplesPerSecond.setPaintTicks(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(1, new JLabel("0.1"));
        ((Dictionary)labels).put(10, new JLabel("1"));
        ((Dictionary)labels).put(19, new JLabel("10"));
        this.samplesPerSecond.setLabelTable(labels);
        this.samplesPerSecond.addChangeListener(changeEvent -> this.updateForSamplesPerSecond());
        timePanel.add(this.samplesPerSecond);
        this.samplesPerSecondValue = new JLabel(" ");
        timePanel.add(this.samplesPerSecondValue);
        timePanel.add(new JLabel("From time"));
        this.timeStartField = new JTextField("0");
        timePanel.add(this.timeStartField);
        this.timeStartLabel = new JLabel(" ");
        this.timeStartLabel.setPreferredSize(new Dimension(90, this.timeStartLabel.getPreferredSize().height));
        timePanel.add(this.timeStartLabel);
        timePanel.add(new JLabel("To time"));
        this.timeEndField = new JTextField("0");
        timePanel.add(this.timeEndField);
        this.timeEndLabel = new JLabel(" ");
        this.timeStartLabel.setPreferredSize(new Dimension(90, this.timeStartLabel.getPreferredSize().height));
        timePanel.add(this.timeEndLabel);
        timePanel.add(Box.createHorizontalGlue());
        this.logEndTimeValue = new JLabel(" ");
        this.logEndTimeValue.setForeground(Color.BLUE);
        this.logEndTimeValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!TrackExportDialog.this.exportDataInChartCheckBox.isSelected()) {
                    TrackExportDialog.this.timeEndField.setText(TrackExportDialog.this.stringFromMicroseconds(TrackExportDialog.this.logReader.getSizeMicroseconds()));
                }
            }
        });
        timePanel.add(this.logEndTimeValue);
        timePanel.add(Box.createHorizontalGlue());
        timePanel.add(Box.createHorizontalGlue());
        this.exportDataInChartCheckBox = new JCheckBox("Visible in chart");
        this.exportDataInChartCheckBox.addItemListener(itemEvent -> this.validateTimeRange(null));
        timePanel.add(this.exportDataInChartCheckBox);
        timePanel.add(Box.createHorizontalGlue());
        SpringUtilities.makeCompactGrid(timePanel, 5, 3, 5, 5, 5, 5);
        timePanel.setAlignmentX(0.0f);
        this.add(timePanel);
        JPanel altitudePanel = new JPanel();
        altitudePanel.setBorder(BorderFactory.createTitledBorder("Altitude"));
        altitudePanel.setLayout(new BoxLayout(altitudePanel, 0));
        altitudePanel.add(new JLabel("Altitude offset"));
        this.altOffsetField = new JTextField("0", 10);
        this.altOffsetField.setPreferredSize(new Dimension(50, this.altOffsetField.getPreferredSize().height));
        altitudePanel.add(this.altOffsetField);
        altitudePanel.add(new JLabel("m"));
        altitudePanel.add(Box.createHorizontalStrut(200));
        altitudePanel.setAlignmentX(0.0f);
        this.add(altitudePanel);
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setAlignmentX(0.0f);
        this.add(this.statusLabel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonExport = new JButton("Export");
        this.buttonExport.addActionListener(e -> this.export());
        buttonsPanel.add(this.buttonExport);
        this.getRootPane().setDefaultButton(this.buttonExport);
        JButton buttonClose = new JButton("Close");
        buttonClose.addActionListener(e -> this.onClose());
        buttonsPanel.add(buttonClose);
        buttonsPanel.setAlignmentX(0.0f);
        this.add(buttonsPanel);
        this.initExportersList(exporters);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TrackExportDialog.this.onClose();
            }
        });
        this.getRootPane().registerKeyboardAction(e -> this.onClose(), KeyStroke.getKeyStroke(27, 0), 1);
        DocumentListener timeChangedListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.validate();
            }

            void validate() {
                if (!TrackExportDialog.this.exportDataInChartCheckBox.isSelected()) {
                    TrackExportDialog.this.validateTimeRange(null);
                }
            }
        };
        this.timeStartField.getDocument().addDocumentListener(timeChangedListener);
        this.timeEndField.getDocument().addDocumentListener(timeChangedListener);
        this.pack();
    }

    private void initExportersList(Map<String, TrackExporter> exporters) {
        for (TrackExporter exporter : exporters.values()) {
            this.exportFormatComboBox.addItem(new ExportFormatItem(exporter.getDescription(), exporter.getName()));
        }
    }

    private String stringFromMicroseconds(long us) {
        return String.format(Locale.ROOT, "%.3f", (double)us / 1000000.0);
    }

    private long getTimeInterval() {
        int value = this.samplesPerSecond.getValue();
        if (value <= 10) {
            return 10000000 / value;
        }
        if (value == 20) {
            return 0L;
        }
        return 1000000 / (value - 9);
    }

    private void setTimeInterval(long interval) {
        if (interval == 0L) {
            this.samplesPerSecond.setValue(20);
        } else if (interval <= 1000000L) {
            this.samplesPerSecond.setValue((int)(1000000L / interval + 9L));
        } else {
            this.samplesPerSecond.setValue((int)(10000000L / interval));
        }
        this.updateForSamplesPerSecond();
    }

    private void updateForSamplesPerSecond() {
        if (this.getTimeInterval() == 0L) {
            this.samplesPerSecondValue.setText("max");
        } else {
            this.samplesPerSecondValue.setText(String.format(Locale.ROOT, "%.1f", 1000000.0 / (double)this.getTimeInterval()));
        }
    }

    private String formatTime(long time) {
        long s = time / 1000000L;
        long ms = time / 1000L % 1000L;
        return String.format(Locale.ROOT, "%02d:%02d:%02d.%03d", (int)(s / 3600L), s / 60L % 60L, s % 60L, ms);
    }

    public void display(LogReader logReader, Range chartRange) {
        if (logReader == null) {
            throw new RuntimeException("Log not opened");
        }
        this.logReader = logReader;
        this.chartRange = chartRange;
        this.readerConfiguration.setTimeStart(logReader.getStartMicroseconds());
        this.readerConfiguration.setTimeEnd(logReader.getStartMicroseconds() + logReader.getSizeMicroseconds());
        this.updateDialogFromConfiguration();
        this.setVisible(true);
    }

    private double getLogSizeInSeconds() {
        return (double)this.logReader.getSizeMicroseconds() / 1000000.0;
    }

    private File getDestinationFile(String extension, String description) {
        JFileChooser fc = new JFileChooser();
        if (this.lastExportDirectory != null) {
            fc.setCurrentDirectory(this.lastExportDirectory);
        }
        FileNameExtensionFilter extensionFilter = new FileNameExtensionFilter(description, extension);
        fc.setFileFilter(extensionFilter);
        fc.setDialogTitle("Export Track");
        int returnVal = fc.showDialog(null, "Export");
        if (returnVal == 0) {
            File exportFile;
            this.lastExportDirectory = fc.getCurrentDirectory();
            String exportFileName = fc.getSelectedFile().toString();
            String exportFileExtension = extensionFilter.getExtensions()[0];
            if (extensionFilter == fc.getFileFilter() && !exportFileName.toLowerCase().endsWith(exportFileExtension)) {
                exportFileName = exportFileName + "." + exportFileExtension;
            }
            if (!(exportFile = new File(exportFileName)).exists()) {
                return exportFile;
            }
            int result = JOptionPane.showConfirmDialog(null, "Do you want to overwrite the existing file?\n" + exportFile.getAbsoluteFile(), "File already exists", 0);
            if (0 == result) {
                return exportFile;
            }
        }
        return null;
    }

    private void export() {
        File file;
        this.updateConfiguration();
        final TrackExporter exporter = this.exporters.get(this.exporterConfiguration.getExportFormat());
        if (exporter != null && null != (file = this.getDestinationFile(exporter.getFileExtension(), exporter.getDescription()))) {
            this.setStatus("Exporting...", false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        TrackReader trackReader = TrackReaderFactory.getTrackReader(TrackExportDialog.this.logReader, TrackExportDialog.this.readerConfiguration);
                        String trackTitle = "Track";
                        exporter.export(trackReader, TrackExportDialog.this.exporterConfiguration, file, trackTitle);
                        TrackExportDialog.this.setStatus(String.format("Exported to \"%s\"", file), false);
                    }
                    catch (Exception e) {
                        TrackExportDialog.this.setStatus(String.format("Export failed: %s", e.getMessage()), true);
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void setStatus(String status, boolean error) {
        this.statusLabel.setText(status);
        if (error) {
            this.statusLabel.setForeground(Color.RED);
        } else {
            this.statusLabel.setForeground(Color.BLACK);
        }
    }

    private Long parseExportTime(JTextField field, JLabel label) {
        try {
            long time = (long)(Double.parseDouble(field.getText()) * 1000000.0);
            label.setText(this.formatTime(time));
            return time;
        }
        catch (NumberFormatException e) {
            label.setText("-");
            return null;
        }
    }

    private boolean validateTimeRange(TrackReaderConfiguration configuration) {
        String errorMsg = null;
        if (this.exportDataInChartCheckBox.isSelected()) {
            long fromTime = (long)(this.chartRange.getLowerBound() * 1000000.0) - this.logReader.getStartMicroseconds();
            long toTime = (long)(this.chartRange.getUpperBound() * 1000000.0) - this.logReader.getStartMicroseconds();
            this.timeStartField.setText(this.stringFromMicroseconds(fromTime));
            this.timeStartField.setEnabled(false);
            this.timeEndField.setText(this.stringFromMicroseconds(toTime));
            this.timeEndField.setEnabled(false);
            this.timeStartLabel.setText(this.formatTime(fromTime));
            this.timeEndLabel.setText(this.formatTime(toTime));
        } else {
            this.timeStartField.setEnabled(true);
            this.timeEndField.setEnabled(true);
            Long timeStart = this.parseExportTime(this.timeStartField, this.timeStartLabel);
            Long timeEnd = this.parseExportTime(this.timeEndField, this.timeEndLabel);
            if (timeStart == null || timeEnd == null) {
                errorMsg = "Invalid export time format";
            } else if (timeStart < 0L || timeEnd <= timeStart) {
                errorMsg = "Invalid export time range";
            } else if (configuration != null) {
                configuration.setTimeStart(timeStart + this.logReader.getStartMicroseconds());
                configuration.setTimeEnd(timeEnd + this.logReader.getStartMicroseconds());
            }
        }
        if (errorMsg != null) {
            this.buttonExport.setEnabled(false);
            this.setStatus(errorMsg, true);
            return false;
        }
        this.buttonExport.setEnabled(true);
        this.setStatus("Ready to export", false);
        return true;
    }

    private boolean updateConfiguration() {
        String errorMsg = null;
        this.exporterConfiguration.setSplitTracksByFlightMode(this.splitTrackByFlightCheckBox.isSelected());
        ExportFormatItem item = (ExportFormatItem)this.exportFormatComboBox.getSelectedItem();
        this.exporterConfiguration.setExportFormat(item.formatName);
        this.readerConfiguration.setTimeInterval(this.getTimeInterval());
        if (this.exportDataInChartCheckBox.isSelected()) {
            this.readerConfiguration.setTimeStart((long)(this.chartRange.getLowerBound() * 1000000.0));
            this.readerConfiguration.setTimeEnd((long)(this.chartRange.getUpperBound() * 1000000.0));
        } else if (!this.validateTimeRange(this.readerConfiguration)) {
            return false;
        }
        try {
            double altOffset = Double.parseDouble(this.altOffsetField.getText());
            this.readerConfiguration.setAltitudeOffset(altOffset);
        }
        catch (NumberFormatException e) {
            errorMsg = "Invalid altitude offset format";
        }
        if (errorMsg != null) {
            this.buttonExport.setEnabled(false);
            this.setStatus(errorMsg, true);
            return false;
        }
        this.buttonExport.setEnabled(true);
        this.setStatus("Ready to export", false);
        return true;
    }

    private void updateDialogFromConfiguration() {
        this.splitTrackByFlightCheckBox.setSelected(this.exporterConfiguration.isSplitTracksByFlightMode());
        if (this.exporterConfiguration.getExportFormat() != null) {
            for (int index = 0; index < this.exportFormatComboBox.getItemCount(); ++index) {
                ExportFormatItem item = (ExportFormatItem)this.exportFormatComboBox.getItemAt(index);
                if (!this.exporterConfiguration.getExportFormat().equals(item.formatName)) continue;
                this.exportFormatComboBox.setSelectedIndex(index);
                break;
            }
        }
        this.timeStartField.setText(this.stringFromMicroseconds(this.readerConfiguration.getTimeStart() - this.logReader.getStartMicroseconds()));
        this.timeEndField.setText(this.stringFromMicroseconds(this.readerConfiguration.getTimeEnd() - this.logReader.getStartMicroseconds()));
        this.altOffsetField.setText(String.valueOf(this.readerConfiguration.getAltitudeOffset()));
        this.setTimeInterval(this.readerConfiguration.getTimeInterval());
        this.logEndTimeValue.setText(" Log end: " + this.stringFromMicroseconds(this.logReader.getSizeMicroseconds()));
        this.validateTimeRange(null);
    }

    private void onClose() {
        this.dispose();
    }

    public void savePreferences(Preferences preferences) {
        PreferencesUtil.saveWindowLocation(this, preferences.node(DIALOG_SETTING));
        this.exporterConfiguration.saveConfiguration(preferences.node(EXPORTER_CONFIGURATION_SETTING));
        this.readerConfiguration.saveConfiguration(preferences.node(READER_CONFIGURATION_SETTING));
        if (this.lastExportDirectory != null) {
            preferences.put(LAST_EXPORT_DIRECTORY_SETTING, this.lastExportDirectory.getAbsolutePath());
        }
    }

    public void loadPreferences(Preferences preferences) {
        PreferencesUtil.loadWindowLocation(this, preferences.node(DIALOG_SETTING));
        this.exporterConfiguration.loadConfiguration(preferences.node(EXPORTER_CONFIGURATION_SETTING));
        this.readerConfiguration.loadConfiguration(preferences.node(READER_CONFIGURATION_SETTING));
        String lastExportDirectoryPath = preferences.get(LAST_EXPORT_DIRECTORY_SETTING, null);
        if (null != lastExportDirectoryPath) {
            this.lastExportDirectory = new File(lastExportDirectoryPath);
        }
    }

    private class ExportFormatItem {
        String description;
        String formatName;

        ExportFormatItem(String description, String formatName) {
            this.description = description;
            this.formatName = formatName;
        }

        public String toString() {
            return this.description;
        }
    }
}

