/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.PlotItem;
import com.microavia.plot.XYPoint;
import java.util.ArrayList;

public class Series
extends ArrayList<XYPoint>
implements PlotItem {
    private final String title;
    private final double skipOut;
    private Double lastTime = null;
    private Double lastValue = null;

    public Series(String title, double skipOut) {
        this.title = title;
        this.skipOut = skipOut;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getFullTitle(String processorTitle) {
        return processorTitle + (this.title.isEmpty() ? "" : ":" + this.title);
    }

    public void addPoint(double time, double value) {
        if (this.lastTime != null && time - this.lastTime < this.skipOut) {
            this.lastValue = value;
            return;
        }
        if (this.lastValue != null && this.lastTime != null && time - this.lastTime > this.skipOut * 2.0) {
            this.add(new XYPoint(this.lastTime, this.lastValue));
        }
        this.lastTime = time;
        this.lastValue = null;
        this.add(new XYPoint(time, value));
    }
}

