/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.PlotApp;
import com.microavia.plot.ProcessorPreset;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;

public class ProcessorsListPanel
extends JPanel {
    private PlotApp app;
    private JTable processorsList;
    private DefaultTableModel processorsListModel;

    public ProcessorsListPanel(final PlotApp app) {
        super(new BorderLayout());
        this.app = app;
        this.setBorder(BorderFactory.createTitledBorder("Processors"));
        this.processorsListModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }

            @Override
            public Class<?> getColumnClass(int col) {
                return col == 0 ? Boolean.class : String.class;
            }
        };
        this.processorsListModel.addColumn("");
        this.processorsListModel.addColumn("Processor");
        this.processorsList = new JTable(this.processorsListModel);
        this.processorsList.getColumnModel().getColumn(0).setMinWidth(20);
        this.processorsList.getColumnModel().getColumn(0).setMaxWidth(20);
        this.processorsList.setSelectionMode(0);
        this.processorsList.getSelectionModel().addListSelectionListener(listSelectionEvent -> app.onProcessorSelected());
        this.processorsList.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.processorsList.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                app.showAddProcessorDialog(true);
            }
        });
        this.processorsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                if (e.getClickCount() > 1 && target.getSelectedColumn() == 1) {
                    app.showAddProcessorDialog(true);
                }
            }
        });
        this.processorsListModel.addTableModelListener(e -> {
            if (e.getType() == 0 && e.getColumn() == 0) {
                app.processFile();
            }
        });
        this.add((Component)this.processorsList, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JButton addProcessorButton = new JButton("Add");
        addProcessorButton.addActionListener(e -> app.showAddProcessorDialog(false));
        buttonsPanel.add(addProcessorButton);
        JButton removeProcessorButton = new JButton("Remove");
        removeProcessorButton.addActionListener(e -> this.removeSelectedProcessor());
        buttonsPanel.add(removeProcessorButton);
        this.add((Component)buttonsPanel, "Last");
    }

    private void removeSelectedProcessor() {
        int row = this.processorsList.getSelectedRow();
        if (row >= 0) {
            this.processorsListModel.removeRow(row);
            this.app.updatePresetEdited(true);
            this.app.updateUsedColors();
            this.app.processFile();
        }
    }

    int getProcessorsCount() {
        return this.processorsListModel.getRowCount();
    }

    void clearProcessors() {
        this.processorsListModel.setRowCount(0);
    }

    void addProcessor(ProcessorPreset pp, boolean select) {
        this.processorsListModel.addRow(new Object[]{true, pp.clone()});
        if (select) {
            int i = this.processorsListModel.getRowCount() - 1;
            this.processorsList.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    ProcessorPreset getProcessor(int idx) {
        return (ProcessorPreset)this.processorsListModel.getValueAt(idx, 1);
    }

    boolean isProcessorEnabled(int idx) {
        return (Boolean)this.processorsListModel.getValueAt(idx, 0);
    }

    List<ProcessorPreset> getActiveProcessors() {
        ArrayList<ProcessorPreset> processors = new ArrayList<ProcessorPreset>();
        for (int idx = 0; idx < this.getProcessorsCount(); ++idx) {
            if (!this.isProcessorEnabled(idx)) continue;
            processors.add(this.getProcessor(idx));
        }
        return processors;
    }

    void updateProcessor(ProcessorPreset preset, ProcessorPreset presetNew) {
        for (int row = 0; row < this.getProcessorsCount(); ++row) {
            if (this.getProcessor(row) != preset) continue;
            this.processorsListModel.setValueAt(presetNew, row, 1);
            this.processorsList.setRowSelectionInterval(row, row);
            break;
        }
    }

    public void selectProcessor(int i) {
        this.processorsList.getSelectionModel().setSelectionInterval(i, i);
    }

    public ProcessorPreset getSelectedProcessor() {
        int i = this.processorsList.getSelectedRow();
        if (i >= 0) {
            return (ProcessorPreset)this.processorsListModel.getValueAt(i, 1);
        }
        return null;
    }
}

