/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.plot.ColorParamTableCellEditor;
import com.microavia.plot.PlotApp;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

class ParamValueTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private PlotApp app;
    private TableCellEditor editor;

    public ParamValueTableCellEditor(PlotApp app) {
        this.app = app;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor != null ? this.editor.getCellEditorValue() : null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.app.setEditingProcessor();
        if (value instanceof Color) {
            this.editor = new ColorParamTableCellEditor(this.app.getColorSupplier());
            ((ColorParamTableCellEditor)this.editor).getComponent().addActionListener(new ActionDelegate());
        } else if (value instanceof String) {
            JTextField textField = new JTextField();
            textField.setFont(table.getFont());
            textField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.editor = new DefaultCellEditor(textField);
            ((JTextField)((DefaultCellEditor)this.editor).getComponent()).addActionListener(new ActionDelegate());
        }
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private class ActionDelegate
    implements ActionListener {
        private ActionDelegate() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParamValueTableCellEditor.this.stopCellEditing();
        }
    }
}

