/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.plot;

import com.microavia.jmalib.log.LogReader;
import com.microavia.plot.PlotApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class LogInfo
extends JDialog {
    private PlotApp app;
    private DefaultTableModel infoTableModel;
    private DefaultTableModel parametersTableModel;
    private DateFormat dateFormat;

    LogInfo(PlotApp app) {
        super((Frame)app, "Log Info");
        this.app = app;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.createUIComponents();
        this.pack();
    }

    void updateInfo(LogReader logReader) {
        while (this.infoTableModel.getRowCount() > 0) {
            this.infoTableModel.removeRow(0);
        }
        while (this.parametersTableModel.getRowCount() > 0) {
            this.parametersTableModel.removeRow(0);
        }
        if (logReader != null) {
            this.infoTableModel.addRow(new Object[]{"Format", logReader.getFormat()});
            this.infoTableModel.addRow(new Object[]{"System Name", logReader.getSystemName()});
            this.infoTableModel.addRow(new Object[]{"System Config", logReader.getSystemConfig()});
            this.infoTableModel.addRow(new Object[]{"Length, s", String.format(Locale.ROOT, "%.3f", (double)logReader.getSizeMicroseconds() * 1.0E-6)});
            String startTimeStr = "";
            if (logReader.getUTCTimeReferenceMicroseconds() > 0L) {
                startTimeStr = this.dateFormat.format(new Date((logReader.getStartMicroseconds() + logReader.getUTCTimeReferenceMicroseconds()) / 1000L)) + " UTC";
            }
            this.infoTableModel.addRow(new Object[]{"Start Time", startTimeStr});
            this.infoTableModel.addRow(new Object[]{"Updates count", logReader.getSizeUpdates()});
            this.infoTableModel.addRow(new Object[]{"Errors", logReader.getErrors().size()});
            Map<String, Object> ver = logReader.getVersion();
            this.infoTableModel.addRow(new Object[]{"Hardware Version", ver.get("HW")});
            this.infoTableModel.addRow(new Object[]{"Firmware Version", ver.get("FW")});
            Map<String, Object> parameters = logReader.getParameters();
            ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.parametersTableModel.addRow(new Object[]{key, parameters.get(key).toString()});
            }
        }
    }

    private void createUIComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.setBorder(BorderFactory.createTitledBorder("Info"));
        this.infoTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.infoTableModel.addColumn("Property");
        this.infoTableModel.addColumn("Value");
        JTable infoTable = new JTable(this.infoTableModel);
        infoPanel.setPreferredSize(new Dimension(300, 600));
        infoPanel.add((Component)new JScrollPane(infoTable), "Center");
        this.getContentPane().add(infoPanel);
        JPanel paramsPanel = new JPanel(new BorderLayout());
        paramsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.parametersTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.parametersTableModel.addColumn("Parameter");
        this.parametersTableModel.addColumn("Value");
        JTable parametersTable = new JTable(this.parametersTableModel);
        paramsPanel.setPreferredSize(new Dimension(300, 600));
        paramsPanel.add((Component)new JScrollPane(parametersTable), "Center");
        JPanel paramsButtons = new JPanel();
        paramsButtons.setLayout(new BoxLayout(paramsButtons, 0));
        JButton saveButton = new JButton("Save As...");
        saveButton.addActionListener(e -> this.app.showExportParametersDialog());
        paramsButtons.add(saveButton);
        paramsPanel.add((Component)paramsButtons, "Last");
        this.getContentPane().add(paramsPanel);
    }
}

