/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log.ulog;

import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.ulog.AbstractParser;
import com.microavia.jmalib.log.ulog.LogParserContext;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

class StructParser
extends AbstractParser {
    private final LinkedHashMap<String, AbstractParser> fields;

    private StructParser(LogParserContext context, LinkedHashMap<String, AbstractParser> fields) {
        super(context);
        this.fields = fields;
        this.setOffset(0);
    }

    StructParser(LogParserContext context, String formatStr) throws FormatErrorException {
        super(context);
        if (formatStr.length() > 1) {
            String[] fieldDescrs = formatStr.split(";");
            this.fields = new LinkedHashMap(fieldDescrs.length);
            for (String fieldDescr : fieldDescrs) {
                String[] p = fieldDescr.split(" ");
                String name = p[1];
                AbstractParser field = AbstractParser.createFromFormatString(context, p[0]);
                this.size += field.size();
                this.fields.put(name, field);
            }
        } else {
            this.fields = new LinkedHashMap(0);
        }
        this.setOffset(0);
    }

    LinkedHashMap<String, AbstractParser> getFields() {
        return this.fields;
    }

    AbstractParser get(String key) {
        return this.fields.get(key);
    }

    @Override
    public AbstractParser clone() {
        LinkedHashMap<String, AbstractParser> fieldsClone = new LinkedHashMap<String, AbstractParser>();
        for (Map.Entry<String, AbstractParser> e : this.fields.entrySet()) {
            fieldsClone.put(e.getKey(), e.getValue().clone());
        }
        return new StructParser(this.context, fieldsClone);
    }

    @Override
    public void setOffset(int offset) {
        this.size = 0;
        for (AbstractParser field : this.fields.values()) {
            field.setOffset(offset);
            offset += field.size();
            this.size += field.size();
        }
    }

    @Override
    public Object parse(ByteBuffer buffer) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(this.fields.size());
        for (Map.Entry<String, AbstractParser> e : this.fields.entrySet()) {
            res.put(e.getKey(), e.getValue().parse(buffer));
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (Map.Entry<String, AbstractParser> e : this.fields.entrySet()) {
            sb.append("    ");
            sb.append(e.getValue().toString());
            sb.append(" ");
            sb.append(e.getKey());
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

