/*
 * Decompiled with CFR 0.152.
 */
package com.microavia.jmalib.log.ulog;

import com.microavia.jmalib.log.FormatErrorException;
import com.microavia.jmalib.log.ValueParser;
import com.microavia.jmalib.log.ulog.ArrayParser;
import com.microavia.jmalib.log.ulog.FieldParser;
import com.microavia.jmalib.log.ulog.LogParserContext;
import com.microavia.jmalib.log.ulog.StructParser;

abstract class AbstractParser
implements ValueParser {
    final LogParserContext context;
    int size = 0;

    AbstractParser(LogParserContext context) {
        this.context = context;
    }

    private static AbstractParser createFromTypeString(LogParserContext context, String typeString) throws FormatErrorException {
        FieldParser field = FieldParser.create(context, typeString);
        if (field != null) {
            return field;
        }
        StructParser struct = context.getStructs().get(typeString);
        if (struct != null) {
            return struct.clone();
        }
        throw new FormatErrorException("Unsupported type: " + typeString);
    }

    static AbstractParser createFromFormatString(LogParserContext context, String formatStr) throws FormatErrorException {
        if (formatStr.contains("[")) {
            String[] q = formatStr.split("\\[");
            String typeString = q[0];
            int arraySize = Integer.parseInt(q[1].split("]")[0]);
            if (typeString.equals("char") || typeString.equals("byte")) {
                return FieldParser.create(context, typeString, arraySize);
            }
            return new ArrayParser(context, AbstractParser.createFromTypeString(context, typeString), arraySize);
        }
        return AbstractParser.createFromTypeString(context, formatStr);
    }

    public abstract AbstractParser clone();

    int size() {
        return this.size;
    }

    public abstract void setOffset(int var1);
}

